/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import com.swetake.util.Qrcode;
import com.zhcs.dt.util.TwoDimensionCodeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.exception.DecodingFailedException;

public class TwoDimensionCode {
    public static void encoderQRCode(String content, String imgPath) {
        TwoDimensionCode.encoderQRCode(content, imgPath, "png", 2);
    }

    public static void encoderQRCode(String content, OutputStream output) {
        TwoDimensionCode.encoderQRCode(content, output, "png", 2);
    }

    public static void encoderQRCode(String content, String imgPath, String imgType) {
        TwoDimensionCode.encoderQRCode(content, imgPath, imgType, 2);
    }

    public static void encoderQRCode(String content, OutputStream output, String imgType) {
        TwoDimensionCode.encoderQRCode(content, output, imgType, 2);
    }

    public static void encoderQRCode(String content, String imgPath, String imgType, int size) {
        try {
            BufferedImage bufImg = TwoDimensionCode.qRCodeCommon(content, imgType, size);
            File imgFile = new File(imgPath);
            ImageIO.write((RenderedImage)bufImg, imgType, imgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void encoderQRCode(String content, OutputStream output, String imgType, int size) {
        try {
            BufferedImage bufImg = TwoDimensionCode.qRCodeCommon(content, imgType, size);
            ImageIO.write((RenderedImage)bufImg, imgType, output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BufferedImage qRCodeCommon(String content, String imgType, int size) {
        BufferedImage bufImg = null;
        size = 10;
        try {
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(size);
            byte[] contentBytes = content.getBytes("utf-8");
            int imgSize = 67 + 12 * (size - 1);
            bufImg = new BufferedImage(imgSize, imgSize, 1);
            Graphics2D gs = bufImg.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, imgSize, imgSize);
            gs.setColor(Color.BLACK);
            int pixoff = 2;
            if (contentBytes.length > 0 && contentBytes.length < 800) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                int i = 0;
                while (i < codeOut.length) {
                    int j = 0;
                    while (j < codeOut.length) {
                        if (codeOut[j][i]) {
                            gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                throw new Exception("QRCode content bytes length = " + contentBytes.length + " not in [0, 800].");
            }
            gs.dispose();
            bufImg.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufImg;
    }

    public static String decoderQRCode(String imgPath) throws Exception {
        File imageFile = new File(imgPath);
        BufferedImage bufImg = null;
        String content = null;
        try {
            bufImg = ImageIO.read(imageFile);
            QRCodeDecoder decoder = new QRCodeDecoder();
            content = new String(decoder.decode((QRCodeImage)new TwoDimensionCodeImage(bufImg)), "utf-8");
        }
        catch (IOException iOException) {
        }
        catch (DecodingFailedException decodingFailedException) {
            // empty catch block
        }
        return content;
    }

    public static String decoderQRCode(InputStream input) {
        BufferedImage bufImg = null;
        String content = null;
        try {
            bufImg = ImageIO.read(input);
            QRCodeDecoder decoder = new QRCodeDecoder();
            content = new String(decoder.decode((QRCodeImage)new TwoDimensionCodeImage(bufImg)), "utf-8");
        }
        catch (IOException e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (DecodingFailedException dfe) {
            System.out.println("Error: " + dfe.getMessage());
            dfe.printStackTrace();
        }
        return content;
    }

    public static void main(String[] args) {
        String imgPath = "F:/a.png";
        String encoderContent = "http://www.baidu.com";
        TwoDimensionCode handler = new TwoDimensionCode();
        TwoDimensionCode.encoderQRCode(encoderContent, imgPath, "png");
        System.out.println("========encoder success");
        System.out.println("\u89e3\u6790\u7ed3\u679c\u5982\u4e0b\uff1a");
        System.out.println("========decoder success!!!");
    }
}

