/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzManager {
    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
    private static String JOB_GROUP_NAME = "FH_JOBGROUP_NAME";
    private static String TRIGGER_GROUP_NAME = "FH_TRIGGERGROUP_NAME";

    public static void addJob(String jobName, Class<? extends Job> cls, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(cls).withIdentity(jobName, JOB_GROUP_NAME).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJob(String jobName, Class<? extends Job> cls, String time, Map<String, Object> parameter) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(cls).withIdentity(jobName, JOB_GROUP_NAME).build();
            jobDetail.getJobDataMap().put("parameterList", parameter);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String time, Map<String, Object> parameter) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            jobDetail.getJobDataMap().put("parameterList", parameter);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(String jobName, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME);
                JobDetail jobDetail = sched.getJobDetail(jobKey);
                Class objJobClass = jobDetail.getJobClass();
                QuartzManager.removeJob(jobName);
                QuartzManager.addJob(jobName, objJobClass, time);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(String triggerName, String triggerGroupName, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)trigger.getCronExpression());
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
                sched.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutdownJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

