/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import com.zhcs.dt.util.PageData;
import com.zhcs.dt.util.Tools;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.servlet.view.document.AbstractXlsView;

public class ObjectExcelView
extends AbstractXlsView {
    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Date date = new Date();
        String filename = Tools.date2Str(date, "yyyyMMddHHmmss");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
        HSSFWorkbook book = (HSSFWorkbook)workbook;
        HSSFSheet sheet = book.createSheet("sheet1");
        List titles = (List)model.get("titles");
        int len = titles.size();
        HSSFCellStyle headerStyle = book.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont headerFont = book.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)11);
        headerStyle.setFont(headerFont);
        short height = 500;
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < len) {
            String title = (String)titles.get(i);
            row.setRowStyle(headerStyle);
            row.createCell(i).setCellValue(title);
            ++i;
        }
        sheet.getRow(0).setHeight(height);
        HSSFCellStyle contentStyle = book.createCellStyle();
        contentStyle.setAlignment(HorizontalAlignment.CENTER);
        List varList = (List)model.get("varList");
        int varCount = varList.size();
        int i2 = 0;
        while (i2 < varCount) {
            PageData vpd = (PageData)varList.get(i2);
            HSSFRow rows = sheet.createRow(i2 + 1);
            int j = 0;
            while (j < len) {
                String varstr = vpd.getString("var" + (j + 1)) != null ? vpd.getString("var" + (j + 1)) : "";
                rows.setRowStyle(contentStyle);
                rows.createCell(j).setCellValue(varstr);
                ++j;
            }
            ++i2;
        }
    }
}

