/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetWeb {
    public static String getHtmlCode(String httpUrl) throws IOException {
        String input;
        String content = "";
        URL url = new URL(httpUrl);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
        while ((input = reader.readLine()) != null) {
            content = String.valueOf(content) + input;
        }
        reader.close();
        return content;
    }

    public static List<String> getImagePathList(String httpUrl) throws IOException {
        String searchImgReg = "<(img|IMG)\\b[^>]*\\b(src|SRC|src2|SRC2)\\b\\s*=\\s*('|\")?([^'\"\n\r\f>]+(\\.jpg|\\.bmp|\\.eps|\\.gif|\\.mif|\\.miff|\\.png|\\.tif|\\.tiff|\\.svg|\\.wmf|\\.jpe|\\.jpeg|\\.dib|\\.ico|\\.tga|\\.cut|\\.pic)\\b)[^>]*>";
        ArrayList<String> imgList = new ArrayList<String>();
        String content = null;
        content = GetWeb.getHtmlCode(httpUrl);
        Pattern pattern = Pattern.compile(searchImgReg);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String imgsrc;
            String quote = matcher.group(3);
            String string = imgsrc = quote == null || quote.trim().length() == 0 ? matcher.group(4).split("\\s+")[0] : matcher.group(4);
            if (!imgsrc.startsWith("http://") && !imgsrc.startsWith("https://")) {
                String[] httpUrlarr = httpUrl.split("/");
                String wwwhost = String.valueOf(httpUrlarr[0]) + "//" + httpUrlarr[2];
                if (!GetWeb.isNetFileAvailable(String.valueOf(wwwhost) + "/" + imgsrc)) {
                    int i = 3;
                    while (i < httpUrlarr.length) {
                        if (GetWeb.isNetFileAvailable(String.valueOf(wwwhost = String.valueOf(wwwhost) + "/" + httpUrlarr[i]) + "/" + imgsrc)) {
                            imgsrc = String.valueOf(wwwhost) + "/" + imgsrc;
                            break;
                        }
                        ++i;
                    }
                } else {
                    imgsrc = String.valueOf(wwwhost) + "/" + imgsrc;
                }
            }
            imgList.add(imgsrc);
        }
        return imgList;
    }

    public static String getTilte(String httpUrl) {
        String searchTitle = "(<title>|<TITLE>)(.*?)(</title>|</TITLE>)";
        Pattern pattern = Pattern.compile(searchTitle);
        try {
            Matcher matcher = pattern.matcher(GetWeb.getHtmlCode(httpUrl));
            if (matcher.find()) {
                return matcher.group(2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static boolean isNetFileAvailable(String strUrl) {
        InputStream netFileInputStream;
        block16: {
            netFileInputStream = null;
            URL url = new URL(strUrl);
            URLConnection urlConn = url.openConnection();
            netFileInputStream = urlConn.getInputStream();
            if (netFileInputStream == null) break block16;
            try {
                if (netFileInputStream != null) {
                    netFileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        try {
            if (netFileInputStream != null) {
                netFileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
        catch (IOException e) {
            try {
                if (netFileInputStream != null) {
                    netFileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    if (netFileInputStream != null) {
                        netFileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

