/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import com.zhcs.dt.util.PathUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class Freemarker {
    public static void print(String ftlName, Map<String, Object> root, String ftlPath) throws Exception {
        try {
            Template temp = Freemarker.getTemplate(ftlName, ftlPath);
            temp.process(root, (Writer)new PrintWriter(System.out));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printFile(String ftlName, Map<String, Object> root, String outFile, String filePath, String ftlPath) throws Exception {
        try {
            File file = new File(String.valueOf(PathUtil.getClasspath()) + filePath + outFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            Template template = Freemarker.getTemplate(ftlName, ftlPath);
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Template getTemplate(String ftlName, String ftlPath) throws Exception {
        try {
            Configuration cfg = new Configuration();
            cfg.setEncoding(Locale.CHINA, "utf-8");
            cfg.setDirectoryForTemplateLoading(new File(String.valueOf(PathUtil.getClassResources()) + "/ftl/" + ftlPath));
            Template temp = cfg.getTemplate(ftlName);
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

