/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.util;

import com.zhcs.dt.util.DateUtil;
import com.zhcs.dt.util.FileUtil;
import com.zhcs.dt.util.PageData;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbFH {
    private static Log logger = LogFactory.getLog(DbFH.class);
    private static Properties pros = DbFH.getPprVue();
    public static Map<String, String> backUpTableList = new ConcurrentHashMap<String, String>();
    public static Map<String, String> recoverTableList = new ConcurrentHashMap<String, String>();
    private static DbFH dbFH = new DbFH();

    public static void main(String[] arg) {
        try {
            String str = DbFH.getDbFH().backup("").toString();
            System.out.println(FileUtil.getFilesize(str));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static DbFH getDbFH() {
        return dbFH;
    }

    public Object backup(String tableName) throws InterruptedException, ExecutionException {
        if (backUpTableList.get(tableName) != null) {
            return null;
        }
        backUpTableList.put(tableName, tableName);
        ExecutorService pool = Executors.newFixedThreadPool(2);
        DbBackUpCallable fhc = new DbBackUpCallable(tableName);
        Future<Object> f1 = pool.submit(fhc);
        String backstr = f1.get().toString();
        pool.shutdown();
        return backstr;
    }

    public Object recover(String tableName, String sqlFilePath) throws InterruptedException, ExecutionException {
        if (recoverTableList.get(tableName) != null) {
            return null;
        }
        recoverTableList.put(tableName, tableName);
        ExecutorService pool = Executors.newFixedThreadPool(2);
        DbRecoverCallable fhc = new DbRecoverCallable(tableName, sqlFilePath);
        Future<Object> f1 = pool.submit(fhc);
        String backstr = f1.get().toString();
        pool.shutdown();
        return backstr;
    }

    public static Object[] getTables(PageData pd) throws ClassNotFoundException, SQLException {
        String dbtype = pd.getString("dbtype");
        String username = pd.getString("username");
        String password = pd.getString("password");
        String address = pd.getString("dbAddress");
        String dbport = pd.getString("dbport");
        String databaseName = pd.getString("databaseName");
        Connection conn = DbFH.getCon(dbtype, username, password, String.valueOf(address) + ":" + dbport, databaseName);
        if ("oracle".equals(dbtype)) {
            databaseName = username.toUpperCase();
        }
        Object[] arrOb = new Object[]{databaseName, DbFH.getTablesByCon(conn, "sqlserver".equals(dbtype) ? null : databaseName), dbtype};
        return arrOb;
    }

    public static Object[] getTables() throws ClassNotFoundException, SQLException {
        String dbtype = pros.getProperty("dbtype");
        String username = pros.getProperty("username");
        String password = pros.getProperty("password");
        String address = pros.getProperty("dbAddress");
        String dbport = pros.getProperty("dbport");
        String databaseName = pros.getProperty("databaseName");
        Connection conn = DbFH.getCon(dbtype, username, password, String.valueOf(address) + ":" + dbport, databaseName);
        if ("oracle".equals(dbtype)) {
            databaseName = username.toUpperCase();
        }
        Object[] arrOb = new Object[]{databaseName, DbFH.getTablesByCon(conn, "sqlserver".equals(dbtype) ? null : databaseName), dbtype};
        return arrOb;
    }

    public static Connection getFHCon() throws ClassNotFoundException, SQLException {
        String dbtype = pros.getProperty("dbtype");
        String username = pros.getProperty("username");
        String password = pros.getProperty("password");
        String address = pros.getProperty("dbAddress");
        String dbport = pros.getProperty("dbport");
        String databaseName = pros.getProperty("databaseName");
        return DbFH.getCon(dbtype, username, password, String.valueOf(address) + ":" + dbport, databaseName);
    }

    public static Connection getFHCon(PageData pd) throws ClassNotFoundException, SQLException {
        String dbtype = pd.getString("dbtype");
        String username = pd.getString("username");
        String password = pd.getString("password");
        String address = pd.getString("dbAddress");
        String dbport = pd.getString("dbport");
        String databaseName = pd.getString("databaseName");
        return DbFH.getCon(dbtype, username, password, String.valueOf(address) + ":" + dbport, databaseName);
    }

    public static Connection getCon(String dbtype, String username, String password, String dburl, String databaseName) throws SQLException, ClassNotFoundException {
        if ("mysql".equals(dbtype)) {
            Class.forName("com.mysql.jdbc.Driver");
            return DriverManager.getConnection("jdbc:mysql://" + dburl + "/" + databaseName + "?user=" + username + "&password=" + password);
        }
        if ("oracle".equals(dbtype)) {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            return DriverManager.getConnection("jdbc:oracle:thin:@" + dburl + ":" + databaseName, username, password);
        }
        if ("sqlserver".equals(dbtype)) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            return DriverManager.getConnection("jdbc:sqlserver://" + dburl + "; DatabaseName=" + databaseName, username, password);
        }
        return null;
    }

    public static List<String> getTablesByCon(Connection conn, String schema) {
        try {
            ArrayList<String> listTb = new ArrayList<String>();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, schema, null, new String[]{"TABLE"});
            while (rs.next()) {
                listTb.add(rs.getString(3));
            }
            ArrayList<String> arrayList = listTb;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getExecStr(String dbtype, String dbpath, String address, String username, String password, String sqlpath, String tableName, String databaseName, String ffilename) {
        StringBuffer sb = new StringBuffer();
        if ("mysql".equals(dbtype)) {
            address = "localhost";
            sb.append(dbpath);
            sb.append("mysqldump ");
            sb.append("--opt ");
            sb.append("-h ");
            sb.append(address);
            sb.append(" ");
            sb.append("--user=");
            sb.append(username);
            sb.append(" ");
            sb.append("--password=");
            sb.append(password);
            sb.append(" ");
            sb.append("--lock-all-tables=true ");
            sb.append("--result-file=");
            sb.append(sqlpath);
            sb.append(String.valueOf("".equals(tableName) ? String.valueOf(databaseName) + "_" + ffilename : String.valueOf(tableName) + "_" + ffilename) + ".sql");
            sb.append(" ");
            sb.append("--default-character-set=utf8 ");
            sb.append(databaseName);
            sb.append(" ");
            sb.append(tableName);
        } else if ("oracle".equals(dbtype)) {
            if ("".equals(tableName)) {
                sb.append("EXP " + username + "/" + password + " BUFFER=880000 FILE=" + sqlpath + username + "_" + ffilename + ".DMP LOG=" + sqlpath + username + "_" + ffilename + ".LOG OWNER=" + username);
            } else {
                sb.append("EXP " + username + "/" + password + " BUFFER=880000 FILE=" + sqlpath + tableName + "_" + ffilename + ".DMP LOG=" + sqlpath + tableName + "_" + ffilename + ".LOG TABLES=(" + username + "." + tableName + ")");
            }
        }
        return sb.toString();
    }

    public static Object[] executeQueryFH(String sql) throws Exception {
        List<Object> columnList = new ArrayList();
        ArrayList dataList = new ArrayList();
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        conn = DbFH.getFHCon();
        stmt = conn.createStatement();
        rs = stmt.executeQuery(sql);
        columnList = DbFH.getFieldLsit(conn, sql);
        while (rs.next()) {
            ArrayList<Object> onedataList = new ArrayList<Object>();
            int i = 1;
            while (i < columnList.size() + 1) {
                onedataList.add(rs.getObject(i));
                ++i;
            }
            dataList.add(onedataList);
        }
        Object[] arrOb = new Object[]{columnList, dataList};
        conn.close();
        return arrOb;
    }

    public static void executeUpdateFH(String sql) throws ClassNotFoundException, SQLException {
        Statement stmt = null;
        Connection conn = null;
        conn = DbFH.getFHCon();
        stmt = conn.createStatement();
        stmt.executeUpdate(sql);
        conn.close();
    }

    public static List<String> getFieldLsit(Connection conn, String table) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(table);
        pstmt.execute();
        ArrayList<String> columnList = new ArrayList<String>();
        ResultSetMetaData rsmd = pstmt.getMetaData();
        int i = 1;
        while (i < rsmd.getColumnCount() + 1) {
            columnList.add(rsmd.getColumnName(i));
            ++i;
        }
        return columnList;
    }

    public static List<Map<String, String>> getFieldParameterLsit(Connection conn, String table) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("select * from " + table);
        pstmt.execute();
        ArrayList<Map<String, String>> columnList = new ArrayList<Map<String, String>>();
        ResultSetMetaData rsmd = pstmt.getMetaData();
        int i = 1;
        while (i < rsmd.getColumnCount() + 1) {
            HashMap<String, String> fmap = new HashMap<String, String>();
            fmap.put("fieldNanme", rsmd.getColumnName(i));
            fmap.put("fieldType", rsmd.getColumnTypeName(i));
            fmap.put("fieldLength", String.valueOf(rsmd.getColumnDisplaySize(i)));
            fmap.put("fieldSccle", String.valueOf(rsmd.getScale(i)));
            columnList.add(fmap);
            ++i;
        }
        return columnList;
    }

    public static Properties getPprVue() {
        InputStream inputStream = DbFH.class.getClassLoader().getResourceAsStream("dbfh.properties");
        Properties p = new Properties();
        try {
            p.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    public static Map<String, String> getDBParameter() {
        HashMap<String, String> fhmap = new HashMap<String, String>();
        fhmap.put("dbtype", pros.getProperty("dbtype"));
        fhmap.put("remoteDB", pros.getProperty("remoteDB"));
        return fhmap;
    }

    class DbBackUpCallable
    implements Callable<Object> {
        String tableName = null;

        public DbBackUpCallable(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public Object call() {
            try {
                String remoteDB = pros.getProperty("remoteDB");
                String DBSeverport = pros.getProperty("DBSeverport");
                String dbtype = pros.getProperty("dbtype");
                String username = pros.getProperty("username");
                String password = pros.getProperty("password");
                String address = pros.getProperty("dbAddress");
                String databaseName = pros.getProperty("databaseName");
                String dbpath = pros.getProperty("dbpath");
                String sqlpath = pros.getProperty("sqlFilePath");
                String ffilename = DateUtil.getSdfTimes();
                String commandStr = "";
                if (!"sqlserver".equals(dbtype)) {
                    sqlpath = String.valueOf(sqlpath) + DateUtil.getDays() + "/";
                    if ("yes".equals(remoteDB)) {
                        commandStr = DbFH.getExecStr(dbtype, dbpath, "localhost", username, password, sqlpath, this.tableName, databaseName, ffilename);
                        Socket ss = null;
                        DataOutputStream bb = null;
                        DataInputStream dat = null;
                        ss = new Socket(address, Integer.parseInt(DBSeverport));
                        bb = new DataOutputStream(ss.getOutputStream());
                        dat = new DataInputStream(ss.getInputStream());
                        bb.writeUTF("FHQ313596790" + commandStr + "FH313596790" + sqlpath);
                        bb.flush();
                        Boolean llm = true;
                        while (llm.booleanValue()) {
                            String returnstr = dat.readUTF();
                            if ("errer".equals(returnstr)) {
                                String string = returnstr;
                                return string;
                            }
                            llm = false;
                            ss.close();
                            bb.close();
                            dat.close();
                        }
                    } else {
                        FileUtil.createDir(String.valueOf(sqlpath) + "/fh.fh");
                        commandStr = DbFH.getExecStr(dbtype, dbpath, address, username, password, sqlpath, this.tableName, databaseName, ffilename);
                        Runtime cmd = Runtime.getRuntime();
                        Process p = cmd.exec(commandStr);
                        p.waitFor();
                    }
                } else {
                    String spath = String.valueOf(sqlpath) + databaseName + "_" + ffilename + ".bak";
                    String bakSQL = "backup database " + databaseName + " to disk=? with init";
                    PreparedStatement bak = DbFH.getFHCon().prepareStatement(bakSQL);
                    bak.setString(1, spath);
                    bak.execute();
                    bak.close();
                }
                String fileType = ".bak";
                if ("mysql".equals(dbtype)) {
                    fileType = ".sql";
                } else if ("oracle".equals(dbtype)) {
                    fileType = ".DMP";
                }
                if ("".equals(this.tableName)) {
                    String string = String.valueOf(sqlpath) + databaseName + "_" + ffilename + fileType;
                    return string;
                }
                String string = String.valueOf(sqlpath) + this.tableName + "_" + ffilename + fileType;
                return string;
            }
            catch (Exception e) {
                logger.error((Object)"\u5907\u4efd\u64cd\u4f5c\u51fa\u73b0\u95ee\u9898", (Throwable)e);
                return "errer";
            }
            finally {
                backUpTableList.remove(this.tableName);
            }
        }
    }

    class DbRecoverCallable
    implements Callable<Object> {
        String tableName = null;
        String sqlFilePath = null;

        public DbRecoverCallable(String tableName, String sqlFilePath) {
            this.tableName = tableName;
            this.sqlFilePath = sqlFilePath;
        }

        @Override
        public Object call() {
            try {
                String remoteDB = pros.getProperty("remoteDB");
                String DBSeverport = pros.getProperty("DBSeverport");
                String dbtype = pros.getProperty("dbtype");
                String username = pros.getProperty("username");
                String password = pros.getProperty("password");
                String address = pros.getProperty("dbAddress");
                String databaseName = pros.getProperty("databaseName");
                String dbpath = pros.getProperty("dbpath");
                if (!"sqlserver".equals(dbtype)) {
                    if ("yes".equals(remoteDB)) {
                        String commandStr = "";
                        commandStr = "mysql".equals(dbtype) ? "FHMysqlHyQ313596790" + dbpath + "mysql -u " + username + " -p" + password + " " + databaseName + "FH313596790" + this.sqlFilePath : "FHOracleHyQ313596790IMP " + username + "/" + password + " FILE=" + this.sqlFilePath + " LOG=" + this.sqlFilePath.replace("DMP", "") + "LOG FULL=Y";
                        Socket ss = null;
                        DataOutputStream bb = null;
                        DataInputStream dat = null;
                        ss = new Socket(address, Integer.parseInt(DBSeverport));
                        bb = new DataOutputStream(ss.getOutputStream());
                        dat = new DataInputStream(ss.getInputStream());
                        bb.writeUTF(commandStr);
                        bb.flush();
                        Boolean llm = true;
                        while (llm.booleanValue()) {
                            String returnstr = dat.readUTF();
                            if ("errer".equals(returnstr)) {
                                String string = returnstr;
                                return string;
                            }
                            llm = false;
                            ss.close();
                            bb.close();
                            dat.close();
                        }
                        return "ok";
                    }
                    if ("mysql".equals(dbtype)) {
                        this.recoverMysql(this.sqlFilePath, dbpath, username, password, databaseName);
                        return "ok";
                    }
                    String oracleCommandStr = "IMP " + username + "/" + password + " FILE=" + this.sqlFilePath + " LOG=" + this.sqlFilePath.replace("DMP", "") + "LOG FULL=Y";
                    Runtime cmd = Runtime.getRuntime();
                    Process p = cmd.exec(oracleCommandStr);
                    p.waitFor();
                    return "ok";
                }
                String reSQL = "use master exec killspid '" + databaseName + "' restore database " + databaseName + " from disk=? with replace";
                PreparedStatement recovery = DbFH.getFHCon().prepareStatement(reSQL);
                recovery.setString(1, this.sqlFilePath);
                if (!recovery.execute()) {
                    return "ok";
                }
                return "errer";
            }
            catch (Exception e) {
                logger.error((Object)"\u8fd8\u539f\u64cd\u4f5c\u51fa\u73b0\u95ee\u9898", (Throwable)e);
                return "errer";
            }
            finally {
                recoverTableList.remove(this.tableName);
            }
        }

        public void recoverMysql(String sqlFilePath, String dbpath, String username, String password, String databaseName) throws IOException {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(String.valueOf(dbpath) + "mysql -u " + username + " -p" + password + " " + databaseName);
            OutputStream outputStream = process.getOutputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlFilePath), "utf8"));
            String str = null;
            StringBuffer sb = new StringBuffer();
            while ((str = br.readLine()) != null) {
                sb.append(String.valueOf(str) + "\r\n");
            }
            str = sb.toString();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "utf-8");
            writer.write(str);
            writer.flush();
            outputStream.close();
            br.close();
            writer.close();
        }
    }
}

