/*
 * Decompiled with CFR 0.152.
 */
package com.zhcs.dt.plugin;

import com.zhcs.dt.entity.Page;
import com.zhcs.dt.util.FHLogger;
import com.zhcs.dt.util.ReflectHelper;
import com.zhcs.dt.util.Tools;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.PropertyException;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PagePlugin
implements Interceptor {
    private static String dialect = "";
    private static String pageSqlId = "";
    protected static FHLogger logger = FHLogger.getLogger(PagePlugin.class);

    public Object intercept(Invocation ivk) throws Throwable {
        if (ivk.getTarget() instanceof RoutingStatementHandler) {
            RoutingStatementHandler statementHandler = (RoutingStatementHandler)ivk.getTarget();
            BaseStatementHandler delegate = (BaseStatementHandler)ReflectHelper.getValueByFieldName(statementHandler, "delegate");
            MappedStatement mappedStatement = (MappedStatement)ReflectHelper.getValueByFieldName(delegate, "mappedStatement");
            logger.info(delegate.getBoundSql().getSql().replaceAll("\r|\n", "").replaceAll("\\s{1,}", " "));
            logger.info(delegate.getParameterHandler().getParameterObject());
            if (mappedStatement.getId().matches(pageSqlId)) {
                String sql;
                BoundSql boundSql = delegate.getBoundSql();
                Object parameterObject = boundSql.getParameterObject();
                if (parameterObject == null) {
                    throw new NullPointerException("parameterObject\u5c1a\u672a\u5b9e\u4f8b\u5316\uff01");
                }
                Connection connection = (Connection)ivk.getArgs()[0];
                String fhsql = sql = boundSql.getSql();
                String countSql = "select count(0) from (" + fhsql + ")  tmp_count";
                PreparedStatement countStmt = connection.prepareStatement(countSql);
                BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
                this.setParameters(countStmt, mappedStatement, countBS, parameterObject);
                ResultSet rs = countStmt.executeQuery();
                int count = 0;
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                rs.close();
                countStmt.close();
                Page page = null;
                if (parameterObject instanceof Page) {
                    page = (Page)parameterObject;
                    page.setEntityOrField(true);
                    page.setTotalResult(count);
                } else {
                    Field pageField = ReflectHelper.getFieldByFieldName(parameterObject, "page");
                    if (pageField != null) {
                        page = (Page)ReflectHelper.getValueByFieldName(parameterObject, "page");
                        if (page == null) {
                            page = new Page();
                        }
                        page.setEntityOrField(false);
                        page.setTotalResult(count);
                        ReflectHelper.setValueByFieldName(parameterObject, "page", page);
                    } else {
                        throw new NoSuchFieldException(String.valueOf(parameterObject.getClass().getName()) + "\u4e0d\u5b58\u5728 page \u5c5e\u6027\uff01");
                    }
                }
                String pageSql = this.generatePageSql(sql, page);
                ReflectHelper.setValueByFieldName(boundSql, "sql", pageSql);
            }
        }
        return ivk.proceed();
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            int i = 0;
            while (i < parameterMappings.size()) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() != ParameterMode.OUT) {
                    Object value;
                    String propertyName = parameterMapping.getProperty();
                    PropertyTokenizer prop = new PropertyTokenizer(propertyName);
                    if (parameterObject == null) {
                        value = null;
                    } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                        value = parameterObject;
                    } else if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (propertyName.startsWith("__frch_") && boundSql.hasAdditionalParameter(prop.getName())) {
                        value = boundSql.getAdditionalParameter(prop.getName());
                        if (value != null) {
                            value = configuration.newMetaObject(value).getValue(propertyName.substring(prop.getName().length()));
                        }
                    } else {
                        value = metaObject == null ? null : metaObject.getValue(propertyName);
                    }
                    TypeHandler typeHandler = parameterMapping.getTypeHandler();
                    if (typeHandler == null) {
                        throw new ExecutorException("There was no TypeHandler found for parameter " + propertyName + " of statement " + mappedStatement.getId());
                    }
                    typeHandler.setParameter(ps, i + 1, value, parameterMapping.getJdbcType());
                }
                ++i;
            }
        }
    }

    private String generatePageSql(String sql, Page page) {
        if (page != null && Tools.notEmpty(dialect)) {
            StringBuffer pageSql = new StringBuffer();
            if ("mysql".equals(dialect)) {
                pageSql.append(sql);
                pageSql.append(" limit " + page.getCurrentResult() + "," + page.getShowCount());
            }
            return pageSql.toString();
        }
        return sql;
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }

    public void setProperties(Properties p) {
        dialect = p.getProperty("dialect");
        if (Tools.isEmpty(dialect)) {
            try {
                throw new PropertyException("dialect property is not found!");
            }
            catch (PropertyException e) {
                e.printStackTrace();
            }
        }
        if (Tools.isEmpty(pageSqlId = p.getProperty("pageSqlId"))) {
            try {
                throw new PropertyException("pageSqlId property is not found!");
            }
            catch (PropertyException e) {
                e.printStackTrace();
            }
        }
    }
}

