/*
 * Decompiled with CFR 0.152.
 */
package com.hik.mcrsdk.talk.module;

import android.media.AudioRecord;
import android.media.AudioTrack;
import com.hik.mcrsdk.util.CLog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AudioStreamManager {
    private static final String TAG = "AudioStreamManager";
    private static final int SAMPLE_RATE_8000 = 8000;
    private static final int AUDIO_BUFFER_SIZE = 1280;
    private static AudioStreamManager mAudioStreamManager = null;
    private Thread mAudioRecordThread = null;
    private AudioRecord mAudioRecord = null;
    private int mAudioBufferSize = 0;
    private byte[] mAudioBuffer = null;
    private boolean mGathering = false;
    private boolean mExitGatherThread = false;
    private AudioCallBack mAudioCallBack = null;
    private AudioTrack mAudioTrack = null;
    private Thread mReadFileThread = null;
    boolean mReading = false;
    boolean mStopRead = false;
    private boolean mTracking;

    public static AudioStreamManager getInstance() {
        if (mAudioStreamManager == null) {
            mAudioStreamManager = new AudioStreamManager();
        }
        return mAudioStreamManager;
    }

    private AudioStreamManager() {
    }

    public void setCallBack(AudioCallBack aAudioCallBack) {
        this.mAudioCallBack = aAudioCallBack;
    }

    public synchronized boolean startGather() {
        block6: {
            if (this.mGathering) {
                CLog.e(TAG, "startGather gathering....");
                return true;
            }
            this.mAudioBufferSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
            CLog.d(TAG, "Audio Buffer Size:" + this.mAudioBufferSize);
            if (this.mAudioBufferSize <= 0) {
                CLog.d(TAG, "Audio Buffer Size:" + this.mAudioBufferSize);
                this.mAudioBufferSize = 1280;
            }
            this.mAudioBuffer = new byte[this.mAudioBufferSize];
            this.mAudioRecord = new AudioRecord(1, 8000, 2, 2, this.mAudioBufferSize);
            if (this.mAudioRecord.getState() != 0) break block6;
            CLog.e(TAG, "startGather AudioRecord STATE UNINITIALIZED");
            return false;
        }
        try {
            this.mAudioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            CLog.e(TAG, "startGather IllegalStateException");
            return false;
        }
        catch (IllegalArgumentException e) {
            CLog.e(TAG, "startGather IllegalArgumentException");
            return false;
        }
        this.mExitGatherThread = false;
        this.mAudioRecordThread = new Thread(null, new GatherThread(), "RecordThread");
        this.mAudioRecordThread.start();
        this.mGathering = true;
        CLog.d(TAG, "startGather success");
        return true;
    }

    public synchronized void stopGather() {
        if (this.mGathering) {
            this.mExitGatherThread = true;
            if (this.mAudioRecordThread != null) {
                try {
                    this.mAudioRecordThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mAudioRecord != null) {
                if (this.mAudioRecord.getRecordingState() == 3) {
                    try {
                        this.mAudioRecord.stop();
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                }
                this.mAudioRecord.release();
                this.mAudioRecord = null;
            }
        }
        this.mGathering = false;
        CLog.d(TAG, "stopGather success");
    }

    public synchronized boolean startPlay() {
        block5: {
            if (this.mTracking) {
                CLog.e(TAG, "startPlay playing ");
                return true;
            }
            int minBufSize = AudioTrack.getMinBufferSize((int)8000, (int)2, (int)2);
            this.mAudioTrack = new AudioTrack(3, 8000, 2, 2, minBufSize, 1);
            if (this.mAudioTrack.getState() != 0) break block5;
            CLog.e(TAG, "startPlay AudioTrack STATE UNINITIALIZED");
            return false;
        }
        try {
            this.mAudioTrack.play();
        }
        catch (IllegalStateException e) {
            this.mAudioTrack.release();
            this.mAudioTrack = null;
            return false;
        }
        catch (IllegalArgumentException e) {
            this.mAudioTrack = null;
            return false;
        }
        this.mTracking = true;
        CLog.d(TAG, "startPlay success");
        return true;
    }

    public synchronized void stopPlay() {
        if (this.mTracking && this.mAudioTrack != null) {
            if (this.mAudioTrack.getPlayState() != 1) {
                try {
                    this.mAudioTrack.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
        this.mTracking = false;
        CLog.d(TAG, "stopPlay success ");
    }

    public void inputPCMData(byte[] data, int dataLen) {
        if (this.mTracking && data != null && this.mAudioTrack != null) {
            this.mAudioTrack.write(data, 0, dataLen);
        }
    }

    public void startReadFile() {
        if (this.mReading) {
            return;
        }
        this.mReadFileThread = new Thread(null, new ReadFileThread(), "ReadFileThread");
        this.mReadFileThread.start();
    }

    public void stopReadFile() {
        this.mStopRead = true;
        if (this.mReadFileThread == null) {
            return;
        }
        try {
            this.mReadFileThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ AudioRecord access$0(AudioStreamManager audioStreamManager) {
        return audioStreamManager.mAudioRecord;
    }

    static /* synthetic */ boolean access$1(AudioStreamManager audioStreamManager) {
        return audioStreamManager.mExitGatherThread;
    }

    static /* synthetic */ boolean access$2(AudioStreamManager audioStreamManager) {
        return audioStreamManager.mGathering;
    }

    static /* synthetic */ byte[] access$3(AudioStreamManager audioStreamManager) {
        return audioStreamManager.mAudioBuffer;
    }

    static /* synthetic */ int access$4(AudioStreamManager audioStreamManager) {
        return audioStreamManager.mAudioBufferSize;
    }

    public static interface AudioCallBack {
        public void onPCMData(byte[] var1);
    }

    class GatherThread
    extends Thread {
        GatherThread() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (AudioStreamManager.access$0(AudioStreamManager.this) != null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if (!AudioStreamManager.access$2(AudioStreamManager.this) || (readResult = AudioStreamManager.access$0(AudioStreamManager.this).read(AudioStreamManager.access$3(AudioStreamManager.this), 0, AudioStreamManager.access$4(AudioStreamManager.this))) <= 0 || AudioStreamManager.access$5(AudioStreamManager.this) == null) continue;
                AudioStreamManager.access$5(AudioStreamManager.this).onPCMData(AudioStreamManager.access$3(AudioStreamManager.this));
lbl5:
                // 3 sources

                ** while (!AudioStreamManager.access$1((AudioStreamManager)AudioStreamManager.this))
            }
lbl6:
            // 1 sources

        }
    }

    class ReadFileThread
    extends Thread {
        ReadFileThread() {
        }

        @Override
        public void run() {
            block14: {
                AudioStreamManager.this.mReading = true;
                String fileName = "/mnt/sdcard/test.pcm";
                byte[] readBytes = new byte[1280];
                int byteread = 0;
                FileInputStream in = null;
                AudioStreamManager.this.mStopRead = false;
                try {
                    try {
                        in = new FileInputStream(fileName);
                        while (!AudioStreamManager.this.mStopRead) {
                            byteread = ((InputStream)in).read(readBytes);
                            if (byteread == -1) {
                                ((InputStream)in).close();
                                in = null;
                                in = new FileInputStream(fileName);
                                continue;
                            }
                            AudioStreamManager.this.mAudioCallBack.onPCMData(readBytes);
                            Thread.sleep(40L);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        if (in == null) break block14;
                        try {
                            ((InputStream)in).close();
                            AudioStreamManager.this.mReading = false;
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                            AudioStreamManager.this.mReading = false;
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

