/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.sample;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.wltea.analyzer.lucene.IKAnalyzer;
import org.wltea.analyzer.lucene.IKQueryParser;
import org.wltea.analyzer.lucene.IKSimilarity;

public class IKAnalyzerDemo {
    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        String fieldName = "text";
        String text = "IK Analyzer\u662f\u4e00\u4e2a\u7ed3\u5408\u8bcd\u5178\u5206\u8bcd\u548c\u6587\u6cd5\u5206\u8bcd\u7684\u4e2d\u6587\u5206\u8bcd\u5f00\u6e90\u5de5\u5177\u5305\u3002\u5b83\u4f7f\u7528\u4e86\u5168\u65b0\u7684\u6b63\u5411\u8fed\u4ee3\u6700\u7ec6\u7c92\u5ea6\u5207\u5206\u7b97\u6cd5\u3002";
        IKAnalyzer analyzer = new IKAnalyzer();
        RAMDirectory directory = null;
        IndexWriter iwriter = null;
        IndexSearcher isearcher = null;
        try {
            try {
                directory = new RAMDirectory();
                iwriter = new IndexWriter((Directory)directory, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
                Document doc = new Document();
                doc.add((Fieldable)new Field("ID", "10000", Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(fieldName, text, Field.Store.YES, Field.Index.ANALYZED));
                iwriter.addDocument(doc);
                iwriter.close();
                isearcher = new IndexSearcher((Directory)directory);
                isearcher.setSimilarity((Similarity)new IKSimilarity());
                String keyword = "\u4e2d\u6587\u5206\u8bcd\u5de5\u5177\u5305";
                Query query = IKQueryParser.parse(fieldName, keyword);
                TopDocs topDocs = isearcher.search(query, 5);
                System.out.println("\u547d\u4e2d\uff1a" + topDocs.totalHits);
                ScoreDoc[] scoreDocs = topDocs.scoreDocs;
                int i = 0;
                while (i < topDocs.totalHits) {
                    Document targetDoc = isearcher.doc(scoreDocs[i].doc);
                    System.out.println("\u5185\u5bb9\uff1a" + targetDoc.toString());
                    ++i;
                }
            }
            catch (CorruptIndexException e) {
                e.printStackTrace();
                if (isearcher != null) {
                    try {
                        isearcher.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (directory != null) {
                    try {
                        directory.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (LockObtainFailedException e) {
                block37: {
                    e.printStackTrace();
                    if (isearcher == null) break block37;
                    try {
                        isearcher.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (directory != null) {
                    try {
                        directory.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                block38: {
                    e.printStackTrace();
                    if (isearcher == null) break block38;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        isearcher.close();
                    }
                    catch (IOException e6) {
                        e6.printStackTrace();
                    }
                }
                if (directory != null) {
                    try {
                        directory.close();
                    }
                    catch (IOException e7) {
                        e7.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (isearcher != null) {
                try {
                    isearcher.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

