/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.AboutBox;
import com.supermap.data.EditHistory;
import com.supermap.data.Enum;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.IDisposable;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextPart;
import com.supermap.data.Workspace;
import com.supermap.mapping.Layer;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.SnapMode;
import com.supermap.mapping.SnapSetting;
import com.supermap.mapping.SnappedElement;
import com.supermap.ui.Action;
import com.supermap.ui.ActionChangedEvent;
import com.supermap.ui.ActionChangedListener;
import com.supermap.ui.ActionCursorChangingEvent;
import com.supermap.ui.ActionCursorChangingListener;
import com.supermap.ui.EditHandleBeginListener;
import com.supermap.ui.EditHandleEvent;
import com.supermap.ui.EditHandleFinishListener;
import com.supermap.ui.EditHandleMoveListener;
import com.supermap.ui.EditHandleOptions;
import com.supermap.ui.EditHandleType;
import com.supermap.ui.GeometryAddedListener;
import com.supermap.ui.GeometryDeletedListener;
import com.supermap.ui.GeometryDeletingListener;
import com.supermap.ui.GeometryEvent;
import com.supermap.ui.GeometryModifiedListener;
import com.supermap.ui.GeometryModifyingListener;
import com.supermap.ui.GeometrySelectedEvent;
import com.supermap.ui.GeometrySelectedListener;
import com.supermap.ui.InteractionMode;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.InternalEditHistory;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalEnvironment;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalHandleDisposable;
import com.supermap.ui.InternalMappingGeoStyle;
import com.supermap.ui.InternalMappingGeometry;
import com.supermap.ui.InternalMappingMap;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.InternalSnapSetting;
import com.supermap.ui.InternalToolkitMappingUI;
import com.supermap.ui.MapControlNative;
import com.supermap.ui.MapControl_this_componentAdapter;
import com.supermap.ui.MapControl_this_keyAdapter;
import com.supermap.ui.MapControl_this_mouseAdapter;
import com.supermap.ui.MapControl_this_mouseMotionAdapter;
import com.supermap.ui.MapControl_this_mouseWheelAdapter;
import com.supermap.ui.PointInputedEvent;
import com.supermap.ui.PointInputedListener;
import com.supermap.ui.RedoneListener;
import com.supermap.ui.SelectionMode;
import com.supermap.ui.TrackMode;
import com.supermap.ui.TrackedEvent;
import com.supermap.ui.TrackedListener;
import com.supermap.ui.TrackingEvent;
import com.supermap.ui.TrackingListener;
import com.supermap.ui.UndoneListener;
import com.supermap.ui.VectorizationSetting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.Timer;

public class MapControl
extends JComponent
implements Serializable,
IDisposable {
    private Map _$39;
    private boolean _$38 = false;
    private boolean _$37;
    private long _$36;
    private InternalBufferImage _$35 = null;
    private BorderLayout _$34 = new BorderLayout();
    transient Vector m_actionChangedListeners;
    transient Vector m_geometrySelectedListeners;
    transient Vector m_geometryDeletingListeners;
    transient Vector m_geometryAddedListeners;
    transient Vector m_geometryModifyingListeners;
    transient Vector m_geometryModifiedListeners;
    transient Vector m_pointInputedListeners;
    transient Vector m_editHandleBeginListeners;
    transient Vector m_editHandleMoveListeners;
    transient Vector m_editHandleFinishListeners;
    transient Vector m_actionCursorChangingListeners;
    transient Vector m_trackingListeners;
    transient Vector m_trackedListeners;
    transient Vector m_geometryDeletedListeners;
    transient Vector m_redoneListeners;
    transient Vector m_undoneListeners;
    private boolean _$33 = false;
    private Action _$32 = Action.NULL;
    private SnappedElement[] _$31 = null;
    private EditHandleOptions _$30 = null;
    private GeoStyle _$29 = null;
    private GeoStyle _$28 = null;
    private TrackMode _$27 = null;
    private InteractionMode _$26 = null;
    private VectorizationSetting _$25 = null;
    private SnapSetting _$24 = null;
    private GeoStyle _$23 = null;
    private ArrayList<Layer> _$22 = new ArrayList();
    private License _$21;
    private int _$20 = 1;
    private Workspace _$19;
    Action m_beforeAction;
    private GeoPoint _$18 = new GeoPoint();
    private double _$17;
    private double _$16;
    private double _$15;
    private double _$14;
    private boolean _$13 = true;
    private boolean _$12 = false;
    private Cursor _$11;
    private Cursor _$10;
    private boolean _$9 = false;
    private EditHistory _$8;
    private boolean _$7 = false;
    private boolean _$6 = false;
    private Timer _$5;
    private Timer _$4;
    private boolean _$3 = false;
    private boolean _$2;
    private ReentrantLock _$1;

    public MapControl() {
        try {
            this._$2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MapControl(Workspace workspace) {
        if (workspace == null) {
            String string = InternalMappingResource.loadString("workspace", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            this._$2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$19 = workspace;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    private void _$14() {
    }

    private void _$13() {
        if (this._$21 != null) {
            this._$21.disconnect();
            this._$21.dispose();
            this._$21 = null;
        }
    }

    void setEditEnviroment() {
        MapControlNative.jni_SetEditEnvironment(this._$36);
    }

    protected static void setEditEnvironment(MapControl mapControl) {
        mapControl.setEditEnviroment();
    }

    public SnapSetting getSnapSetting() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getSnapSetting()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$24 == null) {
            long l = MapControlNative.jni_GetSnapSetting(this._$36);
            this._$24 = InternalSnapSetting.createInstance(l);
        }
        return this._$24;
    }

    public void setSnapSetting(SnapSetting snapSetting) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setSnapSetting(SnapSetting  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapSetting == null) {
            String string = InternalMappingResource.loadString("setSnapSetting(SnapSetting  value)", "Global_ArgumentNull", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)snapSetting);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("SnapSetting value", "Global_ArgumentObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetSnapSetting(this._$36, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)snapSetting));
    }

    public TrackMode getTrackMode() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$27;
    }

    public void setTrackMode(TrackMode trackMode) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!InternalEnum.isDefined(TrackMode.class, (int)trackMode.value())) {
            String string = InternalMappingResource.loadString("TrackMode value", "Global_EnumValueIsError", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$27 = trackMode;
        this.setAction(this.getAction());
    }

    public SnappedElement[] getSnappedElements() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getSnappedElements()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetSnappedElementCount(this._$36);
        this._$31 = null;
        if (n > 0) {
            this._$31 = new SnappedElement[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            double[] dArray = new double[3 * n];
            double[] dArray2 = new double[3 * n];
            MapControlNative.jni_GetSnappedElements(this._$36, nArray, nArray2, nArray3, dArray, dArray2);
            Layers layers = this.getMap().getLayers();
            Layer layer = null;
            for (int i = 0; i < nArray.length; ++i) {
                layer = layers.get(nArray[i]);
                Point2D[] point2DArray = null;
                SnapMode snapMode = (SnapMode)InternalEnum.parseUGCValue(SnapMode.class, nArray3[i]);
                int n2 = snapMode.value();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 32: 
                    case 256: 
                    case 512: 
                    case 4096: 
                    case 8192: {
                        point2DArray = new Point2D[]{new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        break;
                    }
                    case 64: 
                    case 128: 
                    case 1024: 
                    case 2048: {
                        point2DArray = new Point2D[]{new Point2D(), new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        point2DArray[1].setX(dArray[3 * i + 1]);
                        point2DArray[1].setY(dArray2[3 * i + 1]);
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        point2DArray = new Point2D[]{new Point2D(), new Point2D(), new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        point2DArray[1].setX(dArray[3 * i + 1]);
                        point2DArray[1].setY(dArray2[3 * i + 1]);
                        point2DArray[2].setX(dArray[3 * i + 2]);
                        point2DArray[2].setY(dArray2[3 * i + 2]);
                        break;
                    }
                }
                this._$31[i] = new SnappedElement(layer, nArray2[i], snapMode, point2DArray);
            }
        }
        return this._$31;
    }

    public Layer[] getEditableLayers() {
        Object[] objectArray;
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("GetEditableLayers()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$22.clear();
        Map map = this.getMap();
        Layers layers = null;
        if (map != null) {
            layers = map.getLayers();
            objectArray = MapControlNative.jni_getEditableLayer(this._$36);
            for (int i = 0; i < objectArray.length; ++i) {
                this._$22.add(layers.get((int)objectArray[i]));
            }
        }
        objectArray = new Layer[this._$22.size()];
        return this._$22.toArray(objectArray);
    }

    public GeoStyle getAssistantRegionStyle() {
        long l;
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getAssistantRegionStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$23 == null && (l = MapControlNative.jni_GetAssistantRegionStyle(this._$36)) != 0L) {
            this._$23 = InternalMappingGeoStyle.createInstance(l);
        }
        return this._$23;
    }

    public void setAssistantRegionStyle(GeoStyle geoStyle) {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setAssistantRegionStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetAssistantRegionStyle(this._$36, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean canRedo() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isCanRedo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanRedo(this._$36);
    }

    public boolean canUndo() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isCanUndo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanUndo(this._$36);
    }

    public boolean canCut() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isCanCut()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanCut(this._$36);
    }

    public boolean canCopy() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isCanCopy()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanCopy(this._$36);
    }

    public boolean canPaste() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isCanPaste()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanPaste(this._$36);
    }

    public Layer getActiveEditableLayer() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getActiveEditableLayer()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        Layer layer = null;
        int n = MapControlNative.jni_GetActiveEditableLayer(this._$36);
        if (n != -1) {
            layer = this.getMap().getLayers().get(n);
        }
        return layer;
    }

    public void setActiveEditableLayer(Layer layer) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setActiveEditableLayer(Layer  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        Map map = this.getMap();
        Layers layers = map.getLayers();
        int n = -1;
        if (layer != null) {
            n = layers.indexOf(layer.getName());
        }
        MapControlNative.jni_SetActiveEditableLayer(this._$36, n);
    }

    public boolean isMultiLayerEditEnabled() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("isMultiLayerEditEnabled()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMultiLayerEditEnable(this._$36);
    }

    public void setMultiLayerEditEnabled(boolean bl) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setMultiLayerEditEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetMultiLayerEditEnable(this._$36, bl);
    }

    public void setRefreshAtTracked(boolean bl) {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setRefreshAtTracked(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetRefreshAtTracked(this._$36, bl);
    }

    public boolean refreshAtTracked() {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("refreshAtTracked()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_RefreshAtTracked(this._$36);
    }

    public void setRefreshInInvalidArea(boolean bl) {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setRefreshInInvalidArea(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetRefreshInInvalidArea(this._$36, bl);
    }

    public boolean refreshInInvalidArea() {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("refreshInInvalidArea()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_RefreshInInvalidArea(this._$36);
    }

    public VectorizationSetting getVectorizationSetting() {
        long l;
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getVectorlizationSetting()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$25 == null && (l = MapControlNative.jni_GetVectorlizationSetting(this._$36)) != 0L) {
            this._$25 = new VectorizationSetting(l);
        }
        return this._$25;
    }

    public void setVectorizationSetting(VectorizationSetting vectorizationSetting) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setVectorlizationSetting(VectorlizationSetting  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (vectorizationSetting == null) {
            String string = InternalMappingResource.loadString("VectorlizationSetting  value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)vectorizationSetting);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("VectorlizationSetting  value", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        Layers layers = this._$39.getLayers();
        if (!layers.contains(vectorizationSetting.getRasterLayer().getName())) {
            String string = InternalMappingResource.loadString("value.getRasterLayer()", "MapControl_NotContainLayer", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        MapControlNative.jni_SetVectorlizationSetting(this._$36, l);
        if (this._$25 == null) {
            long l2 = MapControlNative.jni_GetVectorlizationSetting(this._$36);
            if (l2 != 0L) {
                this._$25 = new VectorizationSetting(l2);
            }
        } else {
            long l3 = MapControlNative.jni_GetVectorlizationSetting(this._$36);
            this._$25.changeHandle(l3);
        }
        this._$25.setRasterLayer(vectorizationSetting.getRasterLayer());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)vectorizationSetting));
    }

    public Action getAction() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getAction()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetUserAction(this._$36);
        if (n != -1) {
            try {
                this._$32 = (Action)InternalEnum.parseUGCValue(Action.class, n);
            }
            catch (Exception exception) {
                this._$32 = Action.newInstance(n);
            }
        }
        return this._$32;
    }

    public void setAction(Action action) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setAction(Action action)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (action == null) {
            String string = InternalMappingResource.loadString("action", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Action action2 = this.getAction();
        int n = -1;
        try {
            n = InternalEnum.getUGCValue(action);
        }
        catch (Exception exception) {
            n = action.value();
        }
        this._$32 = action;
        int n2 = InternalEnum.getUGCValue(this._$27);
        MapControlNative.jni_SetAction(this._$36, n, n2);
        if (!this.getAction().equals((Object)action2)) {
            ActionChangedEvent actionChangedEvent = new ActionChangedEvent(this, action2, action);
            this.fireActionChanged(actionChangedEvent);
        }
        this._$1(false);
    }

    public boolean getMarginPanEnabled() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getMarginPanEnabled()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMarginPanEnable(this._$36);
    }

    public void setMarginPanEnabled(boolean bl) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetMarginPanEnable(this._$36, bl);
    }

    public double getMarginPanPercent() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getMarginPanPercent()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMarginPanPercent(this._$36);
    }

    public void setMarginPanPercent(double d) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanPercent(double value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = InternalMappingResource.loadString("value", "MapControl_TheArgumentOfMarginPanPercentValueIsInvalid", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetMarginPanPercent(this._$36, d);
    }

    public double getSelectionTolerance() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getSelectionTolerance()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetSelectionTolerance(this._$36);
    }

    public void setSelectionTolerance(double d) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setSelectionTolerance(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetSelectionTolerance(this._$36, d);
    }

    public SelectionMode getSelectionMode() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getSelectionMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetSelectMode(this._$36);
        return (SelectionMode)InternalEnum.parseUGCValue(SelectionMode.class, n);
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setSelectionMode(SelectionMode value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (selectionMode == null) {
            String string = InternalMappingResource.loadString("selectionMode", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(selectionMode);
        MapControlNative.jni_SetSlectMode(this._$36, n);
    }

    public int getSelectionPixelTolerance() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getSelectionPixelTolerance()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$20 = MapControlNative.jni_getSelectionPixelTolerance(this._$36);
        return this._$20;
    }

    public void setSelectionPixelTolerance(int n) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setSelectionPixelTolerance(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$20 = n;
        MapControlNative.jni_setSelectionPixelTolerance(this._$36, this._$20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap() {
        try {
            this._$1.lock();
            this._$4();
            if (this._$36 == 0L) {
                String string = InternalMappingResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this._$39 == null) {
                long l = MapControlNative.jni_GetMap(this._$36);
                if (l == 0L) {
                    Map map = null;
                    return map;
                }
                this._$39 = InternalMappingMap.createInstance(l, this, this._$1);
            }
        }
        finally {
            this._$1.unlock();
        }
        return this._$39;
    }

    public void setInteractionMode(InteractionMode interactionMode) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setInteractionMode(InteractionMode value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$26 = interactionMode;
    }

    public InteractionMode getInteractionMode() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getInteractionMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$26;
    }

    public EditHandleOptions getHandleOptions() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getHandleOptions()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$30 == null) {
            this._$30 = new EditHandleOptions(this);
        }
        return this._$30;
    }

    public void setHandleOptions(EditHandleOptions editHandleOptions) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getHandleOptions()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (editHandleOptions == null) {
            String string = InternalMappingResource.loadString("EditHandleOptions value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Enum[] enumArray = Enum.getEnums(EditHandleType.class);
        for (int i = 0; i < enumArray.length; ++i) {
            EditHandleType editHandleType = (EditHandleType)enumArray[i];
            int n = InternalEnum.getUGCValue(editHandleType);
            MapControlNative.jni_SetEditHandleType(this._$36, n, editHandleOptions.get(editHandleType));
        }
    }

    public GeoStyle getTrackingStyle() {
        long l;
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getTrackingStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$29 == null && (l = MapControlNative.jni_GetTrackingStyle(this._$36)) != 0L) {
            this._$29 = InternalMappingGeoStyle.createInstance(l);
        }
        return this._$29;
    }

    public void setTrackingStyle(GeoStyle geoStyle) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getTrackingStyle(GeoStyle  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetTrackingStyle(this._$36, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public GeoStyle getAssistantLineStyle() {
        long l;
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("getAssistantLineStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$28 == null && (l = MapControlNative.jni_GetAssistantLineStyle(this._$36)) != 0L) {
            this._$28 = InternalMappingGeoStyle.createInstance(l);
        }
        return this._$28;
    }

    public void setAssistantLineStyle(GeoStyle geoStyle) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setAssistantLineStyle(GeoStyle  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetAssistantLineStyle(this._$36, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public void aboutBox() {
        AboutBox aboutBox = new AboutBox();
        aboutBox.setVisible(true);
    }

    public boolean copy() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("copy()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Copy(this._$36);
    }

    public boolean cut() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("cut()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Cut(this._$36);
    }

    public boolean delete() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("delete()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_OnDelete(this._$36);
    }

    public boolean canDelete() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("canDelete()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_CanDelete(this._$36);
    }

    public boolean paste() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Paste(this._$36);
    }

    public boolean redo() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Redo(this._$36);
    }

    public boolean undo() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Undo(this._$36);
    }

    public void doMouseDown(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        this.m_beforeAction = this.getAction();
        if (mouseEvent.getButton() == 1 && this.getAction().equals((Object)Action.CREATETEXT)) {
            long l;
            if (this._$36 != 0L && this._$35 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35)) != 0L) {
                GeoText geoText = new GeoText();
                geoText.getTextStyle().setSizeFixed(false);
                geoText.getTextStyle().setFontName("");
                Point2D point2D = this.getMap().pixelToMap(mouseEvent.getPoint());
                geoText.addPart(new TextPart("", point2D));
                TrackedEvent trackedEvent = new TrackedEvent(this, (Geometry)geoText, this._$17, this._$16, this._$15, this._$14);
                this.fireTracked(trackedEvent);
                if (!geoText.getText().equals("")) {
                    GeoText geoText2 = new GeoText();
                    geoText2.setTextStyle(geoText.getTextStyle());
                    geoText2.addPart(new TextPart(geoText.getText(), point2D));
                    MapControlNative.jni_AddText(this._$36, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                    geoText2.dispose();
                }
            }
        } else if (mouseEvent.getButton() == 2) {
            long l;
            this.setAction(Action.PAN);
            int n = this.getMouseFlag(mouseEvent);
            if (this._$36 != 0L && this._$35 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35)) != 0L) {
                MapControlNative.jni_mousePressed(this._$36, l, 1, n, mouseEvent.getX(), mouseEvent.getY());
                if (this.getAction().equals((Object)Action.PAN) && mouseEvent.getButton() == 2) {
                    this._$7 = true;
                    InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
                } else {
                    InternalMappingMap.setCanRefreshTrackingLayer(this._$39, true);
                }
            }
        } else {
            long l;
            int n = this.getMouseFlag(mouseEvent);
            if (this._$36 != 0L && this._$35 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35)) != 0L) {
                MapControlNative.jni_mousePressed(this._$36, l, mouseEvent.getButton(), n, mouseEvent.getX(), mouseEvent.getY());
                if (this.getAction().equals((Object)Action.PAN) && mouseEvent.getButton() == 1) {
                    this._$7 = true;
                    InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
                } else {
                    InternalMappingMap.setCanRefreshTrackingLayer(this._$39, true);
                }
            }
        }
    }

    public void doMouseMove(MouseEvent mouseEvent) {
        long l;
        this._$1(false);
        int n = this.getMouseFlag(mouseEvent);
        if (this._$36 != 0L && this._$35 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35)) != 0L) {
            MapControlNative.jni_mouseMoved(this._$36, l, n, mouseEvent.getX(), mouseEvent.getY());
            if (this._$7) {
                InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
            }
        }
        this._$1(false);
        this.repaint();
    }

    public void doMouseUp(MouseEvent mouseEvent) {
        if (this._$36 != 0L && this._$35 != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35);
            if (l != 0L) {
                this._$7 = false;
                if (mouseEvent.getButton() == 3) {
                    long l2;
                    if (this.getAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && (l2 = MapControlNative.jni_getTrackGeometry(this._$36)) != 0L) {
                        Geometry geometry = InternalMappingGeometry.createInstance2(l2);
                        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
                        GeoText geoText = new GeoText();
                        geoText.getTextStyle().setSizeFixed(false);
                        geoText.getTextStyle().setFontName("");
                        Point2D point2D = this.getMap().pixelToMap(mouseEvent.getPoint());
                        geoText.addPart(new TextPart("", point2D));
                        GeoCompound geoCompound = new GeoCompound();
                        geoCompound.addPart((Geometry)geoText);
                        geoCompound.addPart(geometry);
                        geoText.dispose();
                        TrackedEvent trackedEvent = new TrackedEvent(this, (Geometry)geoCompound, this._$17, this._$16, this._$15, this._$14);
                        this.fireTracked(trackedEvent);
                        if (!((GeoText)geoCompound.getPart(0)).getText().equals("")) {
                            GeoText geoText2 = new GeoText();
                            geoText2.setTextStyle(((GeoText)geoCompound.getPart(0)).getTextStyle());
                            geoText2.addPart(new TextPart(((GeoText)geoCompound.getPart(0)).getText(), point2D));
                            MapControlNative.jni_AddText(this._$36, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                            geoText2.dispose();
                        }
                    }
                    if (this.getAction().equals((Object)Action.VERTEXADD) || this.getAction().equals((Object)Action.VERTEXEDIT)) {
                        int n = InternalEnum.getUGCValue(this._$27);
                        MapControlNative.jni_SetAction(this._$36, 100, n);
                    }
                } else if (mouseEvent.getButton() == 2) {
                    int n = this.getMouseFlag(mouseEvent);
                    if (l != 0L) {
                        MapControlNative.jni_mouseReleased(this._$36, l, 1, n, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if (this.getAction().equals((Object)Action.PAN)) {
                        InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
                    } else {
                        InternalMappingMap.setCanRefreshTrackingLayer(this._$39, true);
                    }
                    this.setAction(this.m_beforeAction);
                } else {
                    int n = this.getMouseFlag(mouseEvent);
                    MapControlNative.jni_mouseReleased(this._$36, l, mouseEvent.getButton(), n, mouseEvent.getX(), mouseEvent.getY());
                    if (this.getAction().equals((Object)Action.PAN)) {
                        InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
                    } else {
                        InternalMappingMap.setCanRefreshTrackingLayer(this._$39, true);
                    }
                }
            }
            if (!this.getAction().equals((Object)this.m_beforeAction)) {
                ActionChangedEvent actionChangedEvent = new ActionChangedEvent(this, this.m_beforeAction, this.getAction());
                this.fireActionChanged(actionChangedEvent);
            }
            this.repaint();
        }
    }

    public void doMouseWheel(MouseWheelEvent mouseWheelEvent) {
        if (this._$36 != 0L && this._$35 != null) {
            if (!this._$3) {
                if (!this._$11()) {
                    this._$9();
                } else {
                    this._$3(false);
                }
                this._$10();
            } else {
                this._$3(true);
            }
            this._$2(true);
            Point2D point2D = this.getMap().pixelToMap(mouseWheelEvent.getPoint());
            double d = 0.0;
            d = -mouseWheelEvent.getUnitsToScroll() > 0 ? 1.25 : 0.8;
            InternalMappingMap.setCanRefreshTrackingLayer(this._$39, false);
            this.getMap().zoom(d);
            Point2D point2D2 = this.getMap().pixelToMap(mouseWheelEvent.getPoint());
            this.getMap().pan(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            this._$2(false);
            this._$5();
            this.getMap().refresh();
        }
    }

    public void doKeyDown(KeyEvent keyEvent) {
        long l;
        int n = 0;
        if (keyEvent.isShiftDown()) {
            n |= 4;
        }
        if (keyEvent.isControlDown()) {
            n |= 8;
        }
        int n2 = this.getKey(keyEvent);
        if (this._$36 != 0L && this._$35 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35)) != 0L) {
            InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), false);
            if (!(keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                if (keyEvent.getKeyCode() == 90) {
                    this.setAction(Action.ZOOMIN);
                }
                if (keyEvent.getKeyCode() == 88) {
                    this.setAction(Action.ZOOMOUT);
                }
                if (keyEvent.getKeyCode() == 67) {
                    this.setAction(Action.ZOOMFREE2);
                }
                if (keyEvent.getKeyCode() == 65) {
                    this.setAction(Action.PAN);
                }
                if (keyEvent.getKeyCode() == 83) {
                    this.setAction(Action.SELECT2);
                }
            }
            if (keyEvent.getKeyCode() == 116) {
                this.getMap().refresh();
            } else if (keyEvent.getKeyCode() == 117) {
                this.getMap().viewEntire();
            } else {
                this._$1(false);
                MapControlNative.jni_keyPressed(this._$36, l, n2, 1, n);
                this._$1(false);
                if (keyEvent.isControlDown() && (keyEvent.getKeyCode() == 90 || keyEvent.getKeyCode() == 89)) {
                    this.getMap().refresh();
                }
            }
        }
    }

    public boolean doGeometryCreate(Geometry geometry) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("ensureVisible(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalMappingResource.loadString("geometry", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapControlNative.jni_DoGeometryCreate(this._$36, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public void dispose() {
        this.clearHandle();
        if (this._$36 != 0L) {
            MapControlNative.jni_Delete(this._$36);
            this._$36 = 0L;
        }
        if (this._$35 != null) {
            this._$35.dispose();
        }
        this._$13();
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(int n, int n2) {
        ComponentListener componentListener = null;
        if (this.getComponentListeners().length > 0) {
            componentListener = this.getComponentListeners()[0];
            this.removeComponentListener(componentListener);
        }
        super.resize(n, n2);
        if (componentListener != null) {
            this.addComponentListener(componentListener);
        }
        this.this_componentResized();
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    protected static void onDraw(MapControl mapControl) {
        mapControl._$12();
    }

    protected static void refreshEx(MapControl mapControl, Rectangle2D rectangle2D) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)mapControl._$35);
        if (l != 0L && mapControl._$36 != 0L) {
            mapControl._$1(true);
            MapControlNative.jni_RefreshEx(mapControl._$36, l, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            mapControl.repaint();
            mapControl._$1(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _$12() {
        try {
            this._$1.lock();
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35);
            if (l != 0L && this._$36 != 0L) {
                this._$2 = true;
                boolean bl = MapControlNative.jni_OnDraw(this._$36, l);
                this._$2 = false;
                if (!bl) {
                    String string = InternalMappingResource.loadString("", "NotEnoughMemory", "ui_mapping_resources");
                    throw new OutOfMemoryError(string);
                }
            }
        }
        finally {
            this._$1.unlock();
        }
    }

    void clearHandle() {
        if (this._$39 != null) {
            InternalMappingMap.clearHandle(this._$39);
            this._$39 = null;
        }
        this._$19 = null;
        if (this._$29 != null) {
            InternalMappingGeoStyle.clearHandle(this._$29);
            this._$29 = null;
        }
        if (this._$28 != null) {
            InternalMappingGeoStyle.clearHandle(this._$28);
            this._$28 = null;
        }
        if (this._$23 != null) {
            InternalMappingGeoStyle.clearHandle(this._$23);
            this._$28 = null;
        }
        if (this._$24 != null) {
            InternalSnapSetting.clearHandle(this._$24);
            this._$24 = null;
        }
        if (this._$25 != null) {
            InternalHandleDisposable.setIsDisposable(this._$25, true);
            this._$25.dispose();
            this._$25.clearHandle();
            this._$25 = null;
        }
    }

    void mouseMoved(MouseEvent mouseEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseMove(mouseEvent);
        }
    }

    void mouseWheel(MouseWheelEvent mouseWheelEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseWheel(mouseWheelEvent);
        }
    }

    void mouseDragged(MouseEvent mouseEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseMove(mouseEvent);
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseDown(mouseEvent);
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseUp(mouseEvent);
        }
    }

    void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseWheel(mouseWheelEvent);
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        if (this._$26 == InteractionMode.DEFAULT || this._$26 == InteractionMode.CUSTOMMOUSE) {
            this.doKeyDown(keyEvent);
        }
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.this_componentResized();
    }

    private boolean _$11() {
        return MapControlNative.jni_GetZoomRefreshFlag(this._$36);
    }

    private void _$3(boolean bl) {
        MapControlNative.jni_SetZoomRefreshFlag(this._$36, bl);
    }

    private void _$10() {
        this._$5.start();
    }

    private void _$9() {
        this._$5.stop();
    }

    private void _$8() {
        this._$4.start();
    }

    private void _$7() {
        this._$4.stop();
    }

    private boolean _$6() {
        return MapControlNative.jni_IsDelayRequest(this._$36);
    }

    private void _$2(boolean bl) {
        MapControlNative.jni_SetDelayRequest(this._$36, bl);
    }

    private void _$5() {
        MapControlNative.jni_RequestTile(this._$36);
    }

    private void _$2(int n) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35);
        MapControlNative.jni_OnTimer(this._$36, l, n);
    }

    synchronized void this_componentResized() {
        this._$1.lock();
        if (this._$36 != 0L && this._$35 != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$35);
            boolean bl = this._$6 = this.getWidth() == 0 && this.getHeight() == 0;
            if (l != 0L && !this._$6) {
                this._$35.resize(this.getWidth(), this.getHeight());
                MapControlNative.jni_OnSize(this._$36, l);
            }
            Map map = null;
            map = this._$39 == null ? this.getMap() : this._$39;
            InternalMappingMap.resetImageSize(map, this.getWidth(), this.getHeight());
            InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), false);
        }
        this._$1.unlock();
    }

    int getMouseFlag(MouseEvent mouseEvent) {
        int n = 0;
        if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
            n = 8;
        }
        if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
            n = 4;
        }
        return n;
    }

    int getKey(KeyEvent keyEvent) {
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 127: {
                n = 46;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 36: {
                n = 36;
                break;
            }
            case 35: {
                n = 35;
                break;
            }
            case 33: {
                n = 33;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 38: {
                n = 38;
                break;
            }
            case 40: {
                n = 40;
                break;
            }
            case 37: {
                n = 37;
                break;
            }
            case 39: {
                n = 39;
                break;
            }
            default: {
                n = keyEvent.getKeyCode();
            }
        }
        return n;
    }

    protected static void mapControlInvalidate(MapControl mapControl) {
        mapControl._$33 = true;
        mapControl.repaint();
    }

    static void mapControlDrawPaint(MapControl mapControl) {
        Graphics graphics;
        if (mapControl._$2 && (graphics = mapControl.getGraphics()) != null) {
            graphics.drawImage(mapControl._$35.getMemoryImage(), 0, 0, null);
            graphics.dispose();
        }
    }

    static void mapControlStartTimer(MapControl mapControl, int n) {
        mapControl._$8();
    }

    static void mapControlStopTimer(MapControl mapControl, int n) {
        mapControl._$7();
    }

    private void _$4() {
        if (!this._$38) {
            this._$36 = MapControlNative.jni_New(this);
            this._$3();
            this._$35 = new InternalBufferImage(this.getWidth(), this.getHeight());
            if (this._$35.getHeight() == 0 && this._$35.getWidth() == 0) {
                String string = InternalMappingResource.loadString("", "NotEnoughMemory", "ui_mapping_resources");
                throw new OutOfMemoryError(string);
            }
            this._$38 = true;
            this.setBackground(Color.white);
            this.setSelectionMode(SelectionMode.CONTAIN_INNER_POINT);
            if (this._$19 != null) {
                this.getMap().setWorkspace(this._$19);
            }
        }
    }

    private void _$3() {
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_Reset(this._$36);
    }

    protected static void clearEditToolPack(MapControl mapControl) {
        MapControlNative.jni_ClearEditToolPack(mapControl._$36);
    }

    private void _$2() throws Exception {
        this._$1 = new ReentrantLock();
        this.setLayout(this._$34);
        this.setSize(256, 256);
        this.addComponentListener(new MapControl_this_componentAdapter(this));
        this.addMouseListener(new MapControl_this_mouseAdapter(this));
        this.addMouseMotionListener(new MapControl_this_mouseMotionAdapter(this));
        this.addMouseWheelListener(new MapControl_this_mouseWheelAdapter(this));
        this.addKeyListener(new MapControl_this_keyAdapter(this));
        this.setFocusable(true);
        this._$27 = TrackMode.EDIT;
        this._$26 = InteractionMode.DEFAULT;
        this._$37 = true;
        this._$5 = new Timer(400, new MapControl_this_ZoomRefreshTimer(this));
        this._$4 = new Timer(30, new MapControl_this_PanMapTimer(this));
    }

    public boolean getRollingWheelWithoutDelay() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setRollingWheelWithoutDelay(boolean bl) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanPercent(double value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$3 = bl;
    }

    public boolean isCursorCustomized() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$12;
    }

    public void setCursorCustomized(boolean bl) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$12 = bl;
    }

    public boolean isWaitCursorEnabled() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$13;
    }

    public void setWaitCursorEnabled(boolean bl) {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$13 = bl;
    }

    public EditHistory getEditHistory() {
        this._$4();
        if (this._$36 == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            long l = MapControlNative.jni_GetEditHistory(this._$36);
            this._$8 = InternalEditHistory.createInstance(l);
        }
        return this._$8;
    }

    private Cursor _$1() {
        int n = MapControlNative.jni_GetCursorShape(this._$36);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoomIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoomOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getSelectLine();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                if (this.getAction().equals((Object)Action.CREATE_NORTHARROW)) {
                    cursor = Cursors.getCreateNorthArrow();
                    break;
                }
                if (this.getAction().equals((Object)Action.CREATE_MAPSCALE)) {
                    cursor = Cursors.getCreateMapScale();
                    break;
                }
                if (this.getAction().equals((Object)Action.CREATE_GEOLEGEND)) {
                    cursor = Cursors.getCreateGeoLegend();
                    break;
                }
                if (this.getTrackMode().equals((Object)TrackMode.EDITGEOMAP)) {
                    cursor = Cursors.getCreateMap();
                    break;
                }
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
                break;
            }
            case 59: {
                cursor = Cursors.getCreateBSpline();
                break;
            }
            case 60: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 61: {
                cursor = Cursors.getCreateFreePolyline();
                break;
            }
            case 62: {
                cursor = Cursors.getCreateCardinal();
            }
        }
        return cursor;
    }

    private Cursor _$1(int n) {
        int n2 = MapControlNative.jni_GetCursorShape(this._$36);
        Cursor cursor = null;
        switch (n2) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoomIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoomOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect();
                break;
            }
            case 19: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
                break;
            }
            case 57: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 58: {
                cursor = Cursors.getSelectRectangle();
            }
        }
        return cursor;
    }

    private void _$1(boolean bl) {
        if (this._$36 == 0L) {
            return;
        }
        if (this._$12) {
            return;
        }
        if (bl && !this._$13) {
            return;
        }
        Cursor cursor = this.getCursor();
        if (!cursor.equals(Cursors.getBusy())) {
            this._$11 = cursor;
        }
        if (this._$11 != null) {
            Cursor cursor2 = bl ? Cursors.getBusy() : this._$1();
            this._$10 = cursor2;
            if (this._$10 != null && !this._$11.equals(this._$10)) {
                ActionCursorChangingEvent actionCursorChangingEvent = new ActionCursorChangingEvent(this, this._$11, this._$10);
                this.fireActionCursorChanging(actionCursorChangingEvent);
                this._$10 = actionCursorChangingEvent.getFollowingCursor();
            }
            try {
                this.setCursor(this._$10);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void addActionChangedListener(ActionChangedListener actionChangedListener) {
        if (this.m_actionChangedListeners == null) {
            this.m_actionChangedListeners = new Vector();
        }
        if (!this.m_actionChangedListeners.contains(actionChangedListener)) {
            this.m_actionChangedListeners.add(actionChangedListener);
        }
    }

    public synchronized void removeActionChangedListener(ActionChangedListener actionChangedListener) {
        if (this.m_actionChangedListeners != null && this.m_actionChangedListeners.contains(actionChangedListener)) {
            this.m_actionChangedListeners.remove(actionChangedListener);
        }
    }

    protected void fireActionChanged(ActionChangedEvent actionChangedEvent) {
        if (this.m_actionChangedListeners != null) {
            Vector vector = this.m_actionChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ActionChangedListener)vector.elementAt(i)).actionChanged(actionChangedEvent);
            }
        }
    }

    public synchronized void addGeometrySelectedListener(GeometrySelectedListener geometrySelectedListener) {
        if (this.m_geometrySelectedListeners == null) {
            this.m_geometrySelectedListeners = new Vector();
        }
        if (!this.m_geometrySelectedListeners.contains(geometrySelectedListener)) {
            this.m_geometrySelectedListeners.add(geometrySelectedListener);
        }
    }

    public synchronized void removeGeometrySelectedListener(GeometrySelectedListener geometrySelectedListener) {
        if (this.m_geometrySelectedListeners != null && this.m_geometrySelectedListeners.contains(geometrySelectedListener)) {
            this.m_geometrySelectedListeners.remove(geometrySelectedListener);
        }
    }

    protected void fireGeometrySelected(GeometrySelectedEvent geometrySelectedEvent) {
        if (this.m_geometrySelectedListeners != null) {
            Vector vector = this.m_geometrySelectedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometrySelectedListener)vector.elementAt(i)).geometrySelected(geometrySelectedEvent);
            }
        }
    }

    static void geometrySelectedCallBack(MapControl mapControl, int n) {
        if (mapControl != null) {
            GeometrySelectedEvent geometrySelectedEvent = new GeometrySelectedEvent(mapControl, n);
            mapControl.fireGeometrySelected(geometrySelectedEvent);
        }
    }

    public synchronized void addGeometryDeletingListener(GeometryDeletingListener geometryDeletingListener) {
        if (this.m_geometryDeletingListeners == null) {
            this.m_geometryDeletingListeners = new Vector();
        }
        if (!this.m_geometryDeletingListeners.contains(geometryDeletingListener)) {
            this.m_geometryDeletingListeners.add(geometryDeletingListener);
        }
    }

    public synchronized void removeGeometryDeletingListener(GeometryDeletingListener geometryDeletingListener) {
        if (this.m_geometryDeletingListeners != null && this.m_geometryDeletingListeners.contains(geometryDeletingListener)) {
            this.m_geometryDeletingListeners.remove(geometryDeletingListener);
        }
    }

    protected void fireGeometryDeleting(GeometryEvent geometryEvent) {
        if (this.m_geometryDeletingListeners != null) {
            Vector vector = this.m_geometryDeletingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryDeletingListener)vector.elementAt(i)).geometryDeleting(geometryEvent);
            }
        }
    }

    static void geometryDeletingCallBack(MapControl mapControl, long l, int n, long l2) {
        if (mapControl != null) {
            Object object;
            int n2;
            Object object2 = null;
            int n3 = mapControl.getMap().getLayers().getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = mapControl.getMap().getLayers().get(n2);
                long l3 = InternalHandle.getHandle(object);
                if (l3 != l2) continue;
                object2 = object;
                break;
            }
            n2 = InternalToolkitMappingUI.getHandleBooleanValue(l) ? 1 : 0;
            object = new GeometryEvent(mapControl, n, n2 != 0, (Layer)((Object)object2));
            mapControl.fireGeometryDeleting((GeometryEvent)object);
            InternalToolkitMappingUI.setHandleBooleanValue(l, ((GeometryEvent)object).getCancel());
        }
    }

    public synchronized void addGeometryDeletedListener(GeometryDeletedListener geometryDeletedListener) {
        if (this.m_geometryDeletedListeners == null) {
            this.m_geometryDeletedListeners = new Vector();
        }
        if (!this.m_geometryDeletedListeners.contains(geometryDeletedListener)) {
            this.m_geometryDeletedListeners.add(geometryDeletedListener);
        }
    }

    public synchronized void removeGeometryDeletedListener(GeometryDeletedListener geometryDeletedListener) {
        if (this.m_geometryDeletedListeners != null && this.m_geometryDeletedListeners.contains(geometryDeletedListener)) {
            this.m_geometryDeletedListeners.remove(geometryDeletedListener);
        }
    }

    protected void fireGeometryDeleted(GeometryEvent geometryEvent) {
        if (this.m_geometryDeletedListeners != null) {
            Vector vector = this.m_geometryDeletedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryDeletedListener)vector.elementAt(i)).geometryDeleted(geometryEvent);
            }
        }
    }

    static void geometryDeletedCallBack(MapControl mapControl, long l, int n, long l2) {
        if (mapControl != null) {
            Object object;
            int n2;
            Object object2 = null;
            int n3 = mapControl.getMap().getLayers().getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = mapControl.getMap().getLayers().get(n2);
                long l3 = InternalHandle.getHandle(object);
                if (l3 != l2) continue;
                object2 = object;
                break;
            }
            n2 = InternalToolkitMappingUI.getHandleBooleanValue(l) ? 1 : 0;
            object = new GeometryEvent(mapControl, n, n2 != 0, (Layer)((Object)object2));
            mapControl.fireGeometryDeleted((GeometryEvent)object);
            InternalToolkitMappingUI.setHandleBooleanValue(l, ((GeometryEvent)object).getCancel());
        }
    }

    public synchronized void addGeometryAddedListener(GeometryAddedListener geometryAddedListener) {
        if (this.m_geometryAddedListeners == null) {
            this.m_geometryAddedListeners = new Vector();
        }
        if (!this.m_geometryAddedListeners.contains(geometryAddedListener)) {
            this.m_geometryAddedListeners.add(geometryAddedListener);
        }
    }

    public synchronized void removeGeometryAddedListener(GeometryAddedListener geometryAddedListener) {
        if (this.m_geometryAddedListeners != null && this.m_geometryAddedListeners.contains(geometryAddedListener)) {
            this.m_geometryAddedListeners.remove(geometryAddedListener);
        }
    }

    protected void fireGeometryAdded(GeometryEvent geometryEvent) {
        if (this.m_geometryAddedListeners != null) {
            Vector vector = this.m_geometryAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryAddedListener)vector.elementAt(i)).geometryAdded(geometryEvent);
            }
        }
    }

    static void geometryAddedCallBack(MapControl mapControl, int n, long l) {
        if (mapControl != null) {
            Object object;
            int n2;
            Object object2 = null;
            int n3 = mapControl.getMap().getLayers().getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = mapControl.getMap().getLayers().get(n2);
                long l2 = InternalHandle.getHandle(object);
                if (l2 != l) continue;
                object2 = object;
                break;
            }
            n2 = 0;
            object = new GeometryEvent(mapControl, n, n2 != 0, (Layer)((Object)object2));
            mapControl.fireGeometryAdded((GeometryEvent)object);
        }
    }

    public synchronized void addGeometryModifyingListener(GeometryModifyingListener geometryModifyingListener) {
        if (this.m_geometryModifyingListeners == null) {
            this.m_geometryModifyingListeners = new Vector();
        }
        if (!this.m_geometryModifyingListeners.contains(geometryModifyingListener)) {
            this.m_geometryModifyingListeners.add(geometryModifyingListener);
        }
    }

    public synchronized void removeGeometryModifyingListener(GeometryModifyingListener geometryModifyingListener) {
        if (this.m_geometryModifyingListeners != null && this.m_geometryModifyingListeners.contains(geometryModifyingListener)) {
            this.m_geometryModifyingListeners.remove(geometryModifyingListener);
        }
    }

    protected void fireGeometryModifying(GeometryEvent geometryEvent) {
        if (this.m_geometryModifyingListeners != null) {
            Vector vector = this.m_geometryModifyingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryModifyingListener)vector.elementAt(i)).geometryModifying(geometryEvent);
            }
        }
    }

    static void geometryModifyingCallBack(MapControl mapControl, long l, int n, long l2) {
        if (mapControl != null) {
            Object object;
            int n2;
            Object object2 = null;
            int n3 = mapControl.getMap().getLayers().getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = mapControl.getMap().getLayers().get(n2);
                long l3 = InternalHandle.getHandle(object);
                if (l3 == l2) {
                    object2 = object;
                    break;
                }
                if (n2 != n3 - 1) continue;
                return;
            }
            n2 = InternalToolkitMappingUI.getHandleBooleanValue(l) ? 1 : 0;
            object = new GeometryEvent(mapControl, n, n2 != 0, (Layer)((Object)object2));
            mapControl.fireGeometryModifying((GeometryEvent)object);
            InternalToolkitMappingUI.setHandleBooleanValue(l, ((GeometryEvent)object).getCancel());
        }
    }

    public synchronized void addGeometryModifiedListener(GeometryModifiedListener geometryModifiedListener) {
        if (this.m_geometryModifiedListeners == null) {
            this.m_geometryModifiedListeners = new Vector();
        }
        if (!this.m_geometryModifiedListeners.contains(geometryModifiedListener)) {
            this.m_geometryModifiedListeners.add(geometryModifiedListener);
        }
    }

    public synchronized void removeGeometryModifiedListener(GeometryModifiedListener geometryModifiedListener) {
        if (this.m_geometryModifiedListeners != null && this.m_geometryModifiedListeners.contains(geometryModifiedListener)) {
            this.m_geometryModifiedListeners.remove(geometryModifiedListener);
        }
    }

    protected void fireGeometryModified(GeometryEvent geometryEvent) {
        if (this.m_geometryModifiedListeners != null) {
            Vector vector = this.m_geometryModifiedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryModifiedListener)vector.elementAt(i)).geometryModified(geometryEvent);
            }
        }
    }

    static void geometryModifiedCallBack(MapControl mapControl, int n, long l) {
        if (mapControl != null) {
            Object object;
            int n2;
            Object object2 = null;
            int n3 = mapControl.getMap().getLayers().getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = mapControl.getMap().getLayers().get(n2);
                long l2 = InternalHandle.getHandle(object);
                if (l2 == l) {
                    object2 = object;
                    break;
                }
                if (n2 != n3 - 1) continue;
                return;
            }
            n2 = 0;
            object = new GeometryEvent(mapControl, n, n2 != 0, (Layer)((Object)object2));
            mapControl.fireGeometryModified((GeometryEvent)object);
        }
    }

    public synchronized void addPointInputedListener(PointInputedListener pointInputedListener) {
        if (this.m_pointInputedListeners == null) {
            this.m_pointInputedListeners = new Vector();
        }
        if (!this.m_pointInputedListeners.contains(pointInputedListener)) {
            this.m_pointInputedListeners.add(pointInputedListener);
        }
    }

    public synchronized void removePointInputedListener(PointInputedListener pointInputedListener) {
        if (this.m_pointInputedListeners != null && this.m_pointInputedListeners.contains(pointInputedListener)) {
            this.m_pointInputedListeners.remove(pointInputedListener);
        }
    }

    protected void firePointInputed(PointInputedEvent pointInputedEvent) {
        if (this.m_pointInputedListeners != null) {
            Vector vector = this.m_pointInputedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((PointInputedListener)vector.elementAt(i)).pointInputed(pointInputedEvent);
            }
        }
    }

    static void pointInputedCallBack(MapControl mapControl, long l, long l2, long l3) {
        if (mapControl != null) {
            double d = InternalToolkitMappingUI.getHandleDoubleValue(l);
            double d2 = InternalToolkitMappingUI.getHandleDoubleValue(l2);
            double d3 = InternalToolkitMappingUI.getHandleDoubleValue(l3);
            PointInputedEvent pointInputedEvent = new PointInputedEvent(mapControl, d, d2, d3);
            mapControl.firePointInputed(pointInputedEvent);
        }
    }

    public synchronized void addEditHandleBeginListener(EditHandleBeginListener editHandleBeginListener) {
        if (this.m_editHandleBeginListeners == null) {
            this.m_editHandleBeginListeners = new Vector();
        }
        if (!this.m_editHandleBeginListeners.contains(editHandleBeginListener)) {
            this.m_editHandleBeginListeners.add(editHandleBeginListener);
        }
    }

    public synchronized void removeEditHandleBeginListener(EditHandleBeginListener editHandleBeginListener) {
        if (this.m_editHandleBeginListeners != null && this.m_editHandleBeginListeners.contains(editHandleBeginListener)) {
            this.m_editHandleBeginListeners.remove(editHandleBeginListener);
        }
    }

    protected void fireEditHandleBegin(EditHandleEvent editHandleEvent) {
        if (this.m_editHandleBeginListeners != null) {
            Vector vector = this.m_editHandleBeginListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((EditHandleBeginListener)vector.elementAt(i)).editHandleBegin(editHandleEvent);
            }
        }
    }

    Geometry[] getEditGeometries() {
        long[] lArray = MapControlNative.jni_GetEditGeometries(this._$36);
        Geometry[] geometryArray = new Geometry[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geometryArray[i] = InternalMappingGeometry.createInstance2(lArray[i]);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometryArray[i], false);
        }
        return geometryArray;
    }

    static void editHandleBeginCallBack(MapControl mapControl, int n, long l, int[] nArray, double d, double d2) {
        if (mapControl != null) {
            EditHandleEvent editHandleEvent = null;
            EditHandleType editHandleType = null;
            try {
                editHandleType = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)n);
            }
            catch (Exception exception) {
                editHandleType = null;
            }
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(l);
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (nArray.length > 0 && nArray[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray2 = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n2 = -1;
                int[] nArray3 = new int[nArray.length];
                if (nArray[0] - 10 >= 0) {
                    int n3 = 0;
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray[0] - 10 >= (n3 += nArray2[i])) continue;
                        n2 = i;
                        for (int j = 0; j < nArray3.length; ++j) {
                            nArray3[j] = nArray[j] - 10 - (n3 - nArray2[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, nArray3, n2, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleBegin(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(l, editHandleEvent.getCancel());
        }
    }

    public synchronized void addEditHandleMoveListener(EditHandleMoveListener editHandleMoveListener) {
        if (this.m_editHandleMoveListeners == null) {
            this.m_editHandleMoveListeners = new Vector();
        }
        if (!this.m_editHandleMoveListeners.contains(editHandleMoveListener)) {
            this.m_editHandleMoveListeners.add(editHandleMoveListener);
        }
    }

    public synchronized void removeEditHandleMoveListener(EditHandleMoveListener editHandleMoveListener) {
        if (this.m_editHandleMoveListeners != null && this.m_editHandleMoveListeners.contains(editHandleMoveListener)) {
            this.m_editHandleMoveListeners.remove(editHandleMoveListener);
        }
    }

    protected void fireEditHandleMove(EditHandleEvent editHandleEvent) {
        if (this.m_editHandleMoveListeners != null) {
            Vector vector = this.m_editHandleMoveListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((EditHandleMoveListener)vector.elementAt(i)).editHandleMove(editHandleEvent);
            }
        }
    }

    static void editHandleMoveCallBack(MapControl mapControl, int n, long l, int[] nArray, double d, double d2) {
        if (mapControl != null) {
            EditHandleType editHandleType = null;
            try {
                editHandleType = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)n);
            }
            catch (Exception exception) {
                editHandleType = null;
            }
            EditHandleEvent editHandleEvent = null;
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(l);
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (nArray.length > 0 && nArray[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray2 = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n2 = -1;
                int[] nArray3 = new int[nArray.length];
                if (nArray[0] - 10 >= 0) {
                    int n3 = 0;
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray[0] - 10 >= (n3 += nArray2[i])) continue;
                        n2 = i;
                        for (int j = 0; j < nArray3.length; ++j) {
                            nArray3[j] = nArray[j] - 10 - (n3 - nArray2[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, nArray3, n2, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleMove(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(l, editHandleEvent.getCancel());
        }
    }

    public synchronized void addEditHandleFinishListener(EditHandleFinishListener editHandleFinishListener) {
        if (this.m_editHandleFinishListeners == null) {
            this.m_editHandleFinishListeners = new Vector();
        }
        if (!this.m_editHandleFinishListeners.contains(editHandleFinishListener)) {
            this.m_editHandleFinishListeners.add(editHandleFinishListener);
        }
    }

    public synchronized void removeEditHandleFinishListener(EditHandleFinishListener editHandleFinishListener) {
        if (this.m_editHandleFinishListeners != null && this.m_editHandleFinishListeners.contains(editHandleFinishListener)) {
            this.m_editHandleFinishListeners.remove(editHandleFinishListener);
        }
    }

    protected void fireEditHandleFinish(EditHandleEvent editHandleEvent) {
        if (this.m_editHandleFinishListeners != null) {
            Vector vector = this.m_editHandleFinishListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((EditHandleFinishListener)vector.elementAt(i)).editHandleFinish(editHandleEvent);
            }
        }
    }

    static void editHandleFinishCallBack(MapControl mapControl, int n, int[] nArray, double d, double d2) {
        if (mapControl != null) {
            EditHandleType editHandleType = null;
            try {
                editHandleType = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)n);
            }
            catch (Exception exception) {
                editHandleType = null;
            }
            EditHandleEvent editHandleEvent = null;
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (nArray.length > 0 && nArray[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray2 = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n2 = -1;
                int[] nArray3 = new int[nArray.length];
                if (nArray[0] - 10 >= 0) {
                    int n3 = 0;
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray[0] - 10 >= (n3 += nArray2[i])) continue;
                        n2 = i;
                        for (int j = 0; j < nArray3.length; ++j) {
                            nArray3[j] = nArray[j] - 10 - (n3 - nArray2[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, false, nArray3, n2, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, false, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, d, d2, editHandleType, false, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleFinish(editHandleEvent);
        }
    }

    public synchronized void addActionCursorChangingListener(ActionCursorChangingListener actionCursorChangingListener) {
        if (this.m_actionCursorChangingListeners == null) {
            this.m_actionCursorChangingListeners = new Vector();
        }
        if (!this.m_actionCursorChangingListeners.contains(actionCursorChangingListener)) {
            this.m_actionCursorChangingListeners.add(actionCursorChangingListener);
        }
    }

    public synchronized void removeActionCursorChangingListener(ActionCursorChangingListener actionCursorChangingListener) {
        if (this.m_actionCursorChangingListeners != null && this.m_actionCursorChangingListeners.contains(actionCursorChangingListener)) {
            this.m_actionCursorChangingListeners.remove(actionCursorChangingListener);
        }
    }

    protected void fireActionCursorChanging(ActionCursorChangingEvent actionCursorChangingEvent) {
        if (this.m_actionCursorChangingListeners != null) {
            Vector vector = this.m_actionCursorChangingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ActionCursorChangingListener)vector.elementAt(i)).actionCursorChanging(actionCursorChangingEvent);
            }
        }
    }

    public synchronized void addTrackingListener(TrackingListener trackingListener) {
        if (this.m_trackingListeners == null) {
            this.m_trackingListeners = new Vector();
        }
        if (!this.m_trackingListeners.contains(trackingListener)) {
            this.m_trackingListeners.add(trackingListener);
        }
    }

    public synchronized void removeTrackingListener(TrackingListener trackingListener) {
        if (this.m_trackingListeners != null && this.m_trackingListeners.contains(trackingListener)) {
            this.m_trackingListeners.remove(trackingListener);
        }
    }

    protected void fireTracking(TrackingEvent trackingEvent) {
        this._$18.setX(trackingEvent.getX());
        this._$18.setY(trackingEvent.getY());
        this._$16 = trackingEvent.getAngle();
        this._$14 = trackingEvent.getArea();
        this._$15 = trackingEvent.getCurrentAzimuth();
        this._$17 = trackingEvent.getTotalLength();
        if (this.m_trackingListeners != null) {
            Vector vector = this.m_trackingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackingListener)vector.elementAt(i)).tracking(trackingEvent);
            }
        }
    }

    private double _$1(double d, double d2) {
        double d3 = 0.0;
        if (this._$18.getX() == -1.7976931348623157E308 && this._$18.getY() == -1.7976931348623157E308) {
            d3 = this._$18.getY() >= d2 ? Math.asin((this._$18.getX() - d) / Math.sqrt((this._$18.getX() - d) * (this._$18.getX() - d) - (this._$18.getY() - d2) * (this._$18.getY() - d2))) / Math.PI * 180.0 - 90.0 : (this._$18.getX() > d ? 0.0 - (Math.asin((this._$18.getX() - d) / Math.sqrt((this._$18.getX() - d) * (this._$18.getX() - d) - (this._$18.getY() - d2) * (this._$18.getY() - d2))) / Math.PI * 180.0 - 90.0) + 360.0 : 270.0 - Math.asin((this._$18.getX() - d) / Math.sqrt((this._$18.getX() - d) * (this._$18.getX() - d) - (this._$18.getY() - d2) * (this._$18.getY() - d2))) / Math.PI * 180.0);
        }
        return d3;
    }

    static void trackingCallBack(MapControl mapControl, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (mapControl != null) {
            Geometry geometry = null;
            long l = MapControlNative.jni_getTrackingGeometry(mapControl._$36);
            if (l != 0L) {
                geometry = InternalMappingGeometry.createInstance2(l);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            TrackingEvent trackingEvent = new TrackingEvent(mapControl, d, d2, d3, d5, d7, d6, d4, geometry);
            mapControl.fireTracking(trackingEvent);
        }
    }

    public synchronized void addTrackedListener(TrackedListener trackedListener) {
        if (this.m_trackedListeners == null) {
            this.m_trackedListeners = new Vector();
        }
        if (!this.m_trackedListeners.contains(trackedListener)) {
            this.m_trackedListeners.add(trackedListener);
        }
    }

    public synchronized void removeTrackedListener(TrackedListener trackedListener) {
        if (this.m_trackedListeners != null && this.m_trackedListeners.contains(trackedListener)) {
            this.m_trackedListeners.remove(trackedListener);
        }
    }

    protected void fireTracked(TrackedEvent trackedEvent) {
        trackedEvent.setAngle(this._$16);
        trackedEvent.setArea(this._$14);
        trackedEvent.setAzimuth(this._$15);
        trackedEvent.setLength(this._$17);
        if (this.m_trackedListeners != null) {
            Vector vector = this.m_trackedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackedListener)vector.elementAt(i)).tracked(trackedEvent);
            }
        }
    }

    static void trackedCallBack(MapControl mapControl) {
        if (mapControl != null) {
            Geometry geometry = null;
            long l = MapControlNative.jni_getTrackGeometry(mapControl._$36);
            if (l != 0L) {
                geometry = InternalMappingGeometry.createInstance2(l);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            TrackedEvent trackedEvent = new TrackedEvent(mapControl, geometry, 0.0, 0.0, 0.0, 0.0);
            if (!mapControl.getAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && !mapControl.getAction().equals((Object)Action.CREATETEXT)) {
                mapControl.fireTracked(trackedEvent);
            }
        }
    }

    public synchronized void addRedoneListener(RedoneListener redoneListener) {
        if (this.m_redoneListeners == null) {
            this.m_redoneListeners = new Vector();
        }
        if (!this.m_redoneListeners.contains(redoneListener)) {
            this.m_redoneListeners.add(redoneListener);
        }
    }

    public synchronized void removeRedoneListener(RedoneListener redoneListener) {
        if (this.m_redoneListeners != null && this.m_redoneListeners.contains(redoneListener)) {
            this.m_redoneListeners.remove(redoneListener);
        }
    }

    protected void fireRedone(EventObject eventObject) {
        if (this.m_redoneListeners != null) {
            Vector vector = this.m_redoneListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RedoneListener)vector.elementAt(i)).redone(eventObject);
            }
        }
    }

    static void redoneCallBack(MapControl mapControl) {
        if (mapControl != null) {
            EventObject eventObject = new EventObject(mapControl);
            mapControl.fireRedone(eventObject);
        }
    }

    public synchronized void addUndoneListener(UndoneListener undoneListener) {
        if (this.m_undoneListeners == null) {
            this.m_undoneListeners = new Vector();
        }
        if (!this.m_undoneListeners.contains(undoneListener)) {
            this.m_undoneListeners.add(undoneListener);
        }
    }

    public synchronized void removeUndoneListener(UndoneListener undoneListener) {
        if (this.m_undoneListeners != null && this.m_undoneListeners.contains(undoneListener)) {
            this.m_undoneListeners.remove(undoneListener);
        }
    }

    protected void fireUndone(EventObject eventObject) {
        if (this.m_undoneListeners != null) {
            Vector vector = this.m_undoneListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((UndoneListener)vector.elementAt(i)).undone(eventObject);
            }
        }
    }

    static void undoneCallBack(MapControl mapControl) {
        if (mapControl != null) {
            EventObject eventObject = new EventObject(mapControl);
            mapControl.fireUndone(eventObject);
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.getParent() != null && this._$37 && this._$35 != null && this._$35.getHeight() == 256 && this._$35.getWidth() == 256) {
            this._$37 = false;
            this.repaint();
            return;
        }
        if (this._$36 != 0L) {
            if (this._$33) {
                this._$1(true);
                this._$33 = false;
                if (this._$6) {
                    MapControlNative.jni_MapSetRefreshFlag(this._$36, false);
                    this._$6 = false;
                }
                this._$12();
                this._$1(false);
                this._$9 = true;
            }
            if (this._$9) {
                graphics.drawImage(this._$35.getMemoryImage(), 0, 0, null);
            }
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected static long getHandle(MapControl mapControl) {
        return mapControl._$36;
    }

    protected static boolean isPanButtonDown(MapControl mapControl) {
        return mapControl._$7;
    }

    static {
        InternalEnvironment.LoadWrapJ();
    }

    class MapControl_this_PanMapTimer
    implements ActionListener {
        private MapControl _$1;

        MapControl_this_PanMapTimer(MapControl mapControl2) {
            this._$1 = mapControl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this._$1._$2(1);
            Graphics graphics = this._$1.getGraphics();
            if (graphics != null) {
                graphics.drawImage(this._$1._$35.getMemoryImage(), 0, 0, null);
                graphics.dispose();
            }
        }
    }

    class MapControl_this_ZoomRefreshTimer
    implements ActionListener {
        private MapControl _$1;

        MapControl_this_ZoomRefreshTimer(MapControl mapControl2) {
            this._$1 = mapControl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this._$1._$11()) {
                this._$1._$9();
                this._$1._$3(true);
                this._$1.getMap().refresh();
            }
        }
    }

    public static class Cursors {
        private static Cursor _$64 = null;
        private static Cursor _$63 = null;
        private static Cursor _$62 = null;
        private static Cursor _$61 = null;
        private static Cursor _$60 = null;
        private static Cursor _$59 = null;
        private static Cursor _$58 = null;
        private static Cursor _$57 = null;
        private static Cursor _$56 = null;
        private static Cursor _$55 = null;
        private static Cursor _$54 = null;
        private static Cursor _$53 = null;
        private static Cursor _$52 = null;
        private static Cursor _$51 = null;
        private static Cursor _$50 = null;
        private static Cursor _$49 = null;
        private static Cursor _$48 = null;
        private static Cursor _$47 = null;
        private static Cursor _$46 = null;
        private static Cursor _$45 = null;
        private static Cursor _$44 = null;
        private static Cursor _$43 = null;
        private static Cursor _$42 = null;
        private static Cursor _$41 = null;
        private static Cursor _$40 = null;
        private static Cursor _$39 = null;
        private static Cursor _$38 = null;
        private static Cursor _$37 = null;
        private static Cursor _$36 = null;
        private static Cursor _$35 = null;
        private static Cursor _$34 = null;
        private static Cursor _$33 = null;
        private static Cursor _$32 = null;
        private static Cursor _$31 = null;
        private static Cursor _$30 = null;
        private static Cursor _$29 = null;
        private static Cursor _$28 = null;
        private static Cursor _$27 = null;
        private static Cursor _$26 = null;
        private static Cursor _$25 = null;
        private static Cursor _$24 = null;
        private static Cursor _$23 = null;
        private static Cursor _$22 = null;
        private static Cursor _$21 = null;
        private static Cursor _$20 = null;
        private static Cursor _$19 = null;
        private static Cursor _$18 = null;
        private static Cursor _$17 = null;
        private static Cursor _$16 = null;
        private static Cursor _$15 = null;
        private static Cursor _$14 = null;
        private static Cursor _$13 = null;
        private static Cursor _$12 = null;
        private static Cursor _$11 = null;
        private static Cursor _$10 = null;
        private static Cursor _$9 = null;
        private static Cursor _$8 = null;
        private static Cursor _$7 = null;
        private static Cursor _$6 = null;
        private static Cursor _$5;
        private static Cursor _$4;
        private static Cursor _$3;
        private static Cursor _$2;
        private static String _$1;

        private Cursors() {
        }

        private static Cursor _$1(String string) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string2 = uRL.getFile();
            int n = string2.indexOf("com/supermap/ui/MapControl.class");
            string2 = string2.substring(0, n);
            Image image = null;
            String string3 = string2 + "Mapping/Resources/" + string;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + string);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(7, 7), "");
            }
            return cursor;
        }

        private static Cursor _$1(String string, int n, int n2) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string2 = uRL.getFile();
            int n3 = string2.indexOf("com/supermap/ui/MapControl.class");
            string2 = string2.substring(0, n3);
            Image image = null;
            String string3 = string2 + "Mapping/Resources/" + string;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + string);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(n, n2), "");
            }
            return cursor;
        }

        public static Cursor getBusy() {
            if (_$64 == null) {
                _$64 = Cursors._$1(_$1 + "busy.gif");
            }
            return _$64;
        }

        public static void setBusy(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$64 = cursor;
        }

        public static Cursor getArrow() {
            if (_$63 == null) {
                _$63 = Cursors._$1(_$1 + "null.gif", 0, 0);
            }
            return _$63;
        }

        public static void setArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$63 = cursor;
        }

        public static Cursor getMarginPanLeft() {
            if (_$62 == null) {
                _$62 = Cursors._$1(_$1 + "marginPanLeft.gif", 0, 15);
            }
            return _$62;
        }

        public static void setMarginPanLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$62 = cursor;
        }

        public static Cursor getMarginPanRight() {
            if (_$61 == null) {
                _$61 = Cursors._$1(_$1 + "marginPanRight.gif", 30, 10);
            }
            return _$61;
        }

        public static void setMarginPanRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$61 = cursor;
        }

        public static Cursor getMarginPanTop() {
            if (_$60 == null) {
                _$60 = Cursors._$1(_$1 + "marginPanTop.gif", 10, 0);
            }
            return _$60;
        }

        public static void setMarginPanTop(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$60 = cursor;
        }

        public static Cursor getMarginPanBottom() {
            if (_$59 == null) {
                _$59 = Cursors._$1(_$1 + "marginPanBottom.gif", 10, 30);
            }
            return _$59;
        }

        public static void setMarginPanBottom(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$59 = cursor;
        }

        public static Cursor getMarginPanTopLeft() {
            if (_$58 == null) {
                _$58 = Cursors._$1(_$1 + "marginPanTopLeft.gif");
            }
            return _$58;
        }

        public static void setMarginPanTopLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$58 = cursor;
        }

        public static Cursor getMarginPanTopRight() {
            if (_$57 == null) {
                _$57 = Cursors._$1(_$1 + "marginPanTopRight.gif", 30, 0);
            }
            return _$57;
        }

        public static void setMarginPanTopRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$57 = cursor;
        }

        public static Cursor getMarginPanBottomRight() {
            if (_$56 == null) {
                _$56 = Cursors._$1(_$1 + "marginPanBottomRight.gif", 30, 30);
            }
            return _$56;
        }

        public static Cursor getMarginPanBottomLeft() {
            if (_$55 == null) {
                _$55 = Cursors._$1(_$1 + "marginPanBottomLeft.gif", 0, 30);
            }
            return _$55;
        }

        public static void setMarginPanBottomLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$55 = cursor;
        }

        public static Cursor getZoomFree() {
            if (_$54 == null) {
                _$54 = Cursors._$1(_$1 + "zoomfree.gif");
            }
            return _$54;
        }

        public static void setZoomFree(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$54 = cursor;
        }

        public static Cursor getZoomFree2() {
            if (_$52 == null) {
                _$52 = Cursors._$1(_$1 + "zoomfree.gif");
            }
            return _$52;
        }

        public static void setZoomFree2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$52 = cursor;
        }

        public static Cursor getPan() {
            if (_$50 == null) {
                _$50 = Cursors._$1(_$1 + "pan.gif");
            }
            return _$50;
        }

        public static void setPan(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$50 = cursor;
        }

        public static Cursor getPan2() {
            if (_$53 == null) {
                _$53 = Cursors._$1(_$1 + "pan.gif");
            }
            return _$53;
        }

        public static void setPan2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$53 = cursor;
        }

        public static Cursor getZoomIn() {
            if (_$48 == null) {
                _$48 = Cursors._$1(_$1 + "zoomin.gif");
            }
            return _$48;
        }

        public static void setZoomIn(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$48 = cursor;
        }

        public static Cursor getZoomOut() {
            if (_$49 == null) {
                _$49 = Cursors._$1(_$1 + "zoomout.gif");
            }
            return _$49;
        }

        public static void setZoomOut(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$49 = cursor;
        }

        public static Cursor getSelect() {
            if (_$51 == null) {
                _$51 = Cursors._$1(_$1 + "select.gif", 4, 5);
            }
            return _$51;
        }

        public static void setSelect(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$51 = cursor;
        }

        public static Cursor getSelect2() {
            if (_$45 == null) {
                _$45 = Cursors._$1(_$1 + "select.gif", 4, 5);
            }
            return _$45;
        }

        public static void setSelect2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$45 = cursor;
        }

        public static Cursor getSelectCircle() {
            if (_$42 == null) {
                _$42 = Cursors._$1(_$1 + "selectCircle.gif", 0, 0);
            }
            return _$42;
        }

        public static void setSelectCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$42 = cursor;
        }

        public static Cursor getSelectRegion() {
            if (_$47 == null) {
                _$47 = Cursors._$1(_$1 + "selectregion.gif", 0, 0);
            }
            return _$47;
        }

        public static void setSelectRegion(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$47 = cursor;
        }

        public static Cursor getSelectLine() {
            if (_$46 == null) {
                _$46 = Cursors._$1(_$1 + "selectLine.gif", 0, 0);
            }
            return _$46;
        }

        public static void setSelectLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$46 = cursor;
        }

        public static Cursor getCreatePoint() {
            if (_$43 == null) {
                _$43 = Cursors._$1(_$1 + "createPoint.gif");
            }
            return _$43;
        }

        public static void setCreatePoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$43 = cursor;
        }

        public static Cursor getCreateLine() {
            if (_$44 == null) {
                _$44 = Cursors._$1(_$1 + "createline.gif");
            }
            return _$44;
        }

        public static void setCreateLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$44 = cursor;
        }

        public static Cursor getCreatePolyline() {
            if (_$41 == null) {
                _$41 = Cursors._$1(_$1 + "createPolyLine.gif");
            }
            return _$41;
        }

        public static void setCreatePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$41 = cursor;
        }

        public static Cursor getCreateEllipseArc() {
            if (_$27 == null) {
                _$27 = Cursors._$1(_$1 + "createEllipseArc.gif");
            }
            return _$27;
        }

        public static void setCreateEllipseArc(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$27 = cursor;
        }

        public static Cursor getCreateArc3P() {
            if (_$26 == null) {
                _$26 = Cursors._$1(_$1 + "createArc3p.gif");
            }
            return _$26;
        }

        public static void setCreateArc3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$26 = cursor;
        }

        public static Cursor getCreateCurve() {
            if (_$25 == null) {
                _$25 = Cursors._$1(_$1 + "createCurve.gif");
            }
            return _$25;
        }

        public static void setCreateCurve(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$25 = cursor;
        }

        public static Cursor getCreateRectangle() {
            if (_$24 == null) {
                _$24 = Cursors._$1(_$1 + "createRectangle.gif");
            }
            return _$24;
        }

        public static void setCreateRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$24 = cursor;
        }

        public static Cursor getCreateRoundRectangle() {
            if (_$31 == null) {
                _$31 = Cursors._$1(_$1 + "createRoundRectangle.gif");
            }
            return _$31;
        }

        public static void setCreateRoundRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$31 = cursor;
        }

        public static Cursor getCreateCircle() {
            if (_$40 == null) {
                _$40 = Cursors._$1(_$1 + "createCircle.gif");
            }
            return _$40;
        }

        public static void setCreateCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$40 = cursor;
        }

        public static Cursor getCreateCircle2P() {
            if (_$30 == null) {
                _$30 = Cursors._$1(_$1 + "createCircle2p.gif");
            }
            return _$30;
        }

        public static void setCreateCircle2P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$30 = cursor;
        }

        public static Cursor getCreateCircle3P() {
            if (_$29 == null) {
                _$29 = Cursors._$1(_$1 + "createCircle3p.gif");
            }
            return _$29;
        }

        public static void setCreateCircle3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$29 = cursor;
        }

        public static Cursor getCreateEllipse() {
            if (_$28 == null) {
                _$28 = Cursors._$1(_$1 + "createEllipse.gif");
            }
            return _$28;
        }

        public static void setCreateEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$28 = cursor;
        }

        public static Cursor getCreateObliqueEllipse() {
            if (_$13 == null) {
                _$13 = Cursors._$1(_$1 + "createObliqueEllipse.gif");
            }
            return _$13;
        }

        public static void setCreateObliqueEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$13 = cursor;
        }

        public static Cursor getCreatePolygon() {
            if (_$39 == null) {
                _$39 = Cursors._$1(_$1 + "createPolygon.gif");
            }
            return _$39;
        }

        public static void setCreatePolygon(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$39 = cursor;
        }

        public static Cursor getCreateText() {
            if (_$38 == null) {
                _$38 = Cursors._$1(_$1 + "createText.gif");
            }
            return _$38;
        }

        public static void setCreateText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$38 = cursor;
        }

        public static Cursor getCreateAlongLineText() {
            if (_$37 == null) {
                _$37 = Cursors._$1(_$1 + "createAlongLineText.gif");
            }
            return _$37;
        }

        public static void setCreateAlongLineText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$37 = cursor;
        }

        public static Cursor getCreateParallel() {
            if (_$36 == null) {
                _$36 = Cursors._$1(_$1 + "createparallel.gif");
            }
            return _$36;
        }

        public static void setCreateParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$36 = cursor;
        }

        public static Cursor getCreatePie() {
            if (_$35 == null) {
                _$35 = Cursors._$1(_$1 + "createPie.gif");
            }
            return _$35;
        }

        public static void setCreatePie(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$35 = cursor;
        }

        public static Cursor getCreateParallelogram() {
            if (_$34 == null) {
                _$34 = Cursors._$1(_$1 + "createParallelogram.gif");
            }
            return _$34;
        }

        public static void setCreateParallelogram(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$34 = cursor;
        }

        public static Cursor getCross() {
            if (_$33 == null) {
                _$33 = Cursors._$1(_$1 + "cross.gif");
            }
            return _$33;
        }

        public static void setCross(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$33 = cursor;
        }

        public static Cursor getRotation() {
            if (_$32 == null) {
                _$32 = Cursors._$1(_$1 + "rotation.gif");
            }
            return _$32;
        }

        public static void setRotation(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$32 = cursor;
        }

        public static Cursor getBeam() {
            if (_$23 == null) {
                _$23 = Cursors._$1(_$1 + "beam.gif");
            }
            return _$23;
        }

        public static void setBeam(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$23 = cursor;
        }

        public static Cursor getMove() {
            if (_$22 == null) {
                _$22 = Cursors._$1(_$1 + "move.gif", 0, 0);
            }
            return _$22;
        }

        public static void setMove(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$22 = cursor;
        }

        public static Cursor getNorthSouth() {
            if (_$21 == null) {
                _$21 = Cursors._$1(_$1 + "northSouth.gif");
            }
            return _$21;
        }

        public static void setNorthSouth(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$21 = cursor;
        }

        public static Cursor getWestEast() {
            if (_$20 == null) {
                _$20 = Cursors._$1(_$1 + "weateast.gif");
            }
            return _$20;
        }

        public static void setWestEast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$20 = cursor;
        }

        public static Cursor getNortheastSouthwest() {
            if (_$19 == null) {
                _$19 = Cursors._$1(_$1 + "northeastSouthwest.gif");
            }
            return _$19;
        }

        public static void setNortheastSouthwest(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$19 = cursor;
        }

        public static Cursor getNorthwestSoutheast() {
            if (_$18 == null) {
                _$18 = Cursors._$1(_$1 + "northwestSoutheast.gif");
            }
            return _$18;
        }

        public static void setNorthwestSoutheast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$18 = cursor;
        }

        public static Cursor getSnapPoint() {
            if (_$17 == null) {
                _$17 = Cursors._$1(_$1 + "snapPoint.gif");
            }
            return _$17;
        }

        public static void setSnapPoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$17 = cursor;
        }

        public static Cursor getSnapVertex() {
            if (_$16 == null) {
                _$16 = Cursors._$1(_$1 + "snapVertex.gif");
            }
            return _$16;
        }

        public static void setSnapVertex(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$16 = cursor;
        }

        public static Cursor getSnapMidpoint() {
            if (_$15 == null) {
                _$15 = Cursors._$1(_$1 + "snapMidpoint.gif");
            }
            return _$15;
        }

        public static void setSnapMidpoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$15 = cursor;
        }

        public static Cursor getSnapLine() {
            if (_$14 == null) {
                _$14 = Cursors._$1(_$1 + "snapLine.gif");
            }
            return _$14;
        }

        public static void setSnapLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$14 = cursor;
        }

        public static Cursor getSnapVertical() {
            if (_$12 == null) {
                _$12 = Cursors._$1(_$1 + "snapVertical.gif");
            }
            return _$12;
        }

        public static void setSnapVertical(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$12 = cursor;
        }

        public static Cursor getSnapParallel() {
            if (_$11 == null) {
                _$11 = Cursors._$1(_$1 + "snapParallel.gif");
            }
            return _$11;
        }

        public static void setSnapParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$11 = cursor;
        }

        public static Cursor getMoveRotationBase() {
            if (_$10 == null) {
                _$10 = Cursors._$1(_$1 + "moveRotationBase.gif");
            }
            return _$10;
        }

        public static void setMoveRotationBase(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$10 = cursor;
        }

        public static Cursor getSelectRectangle() {
            if (_$9 == null) {
                _$9 = Cursors._$1(_$1 + "selectRect.gif", 0, 0);
            }
            return _$9;
        }

        public static void setSelectRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$9 = cursor;
        }

        public static Cursor getCreateNorthArrow() {
            if (_$8 == null) {
                _$8 = Cursors._$1(_$1 + "createNorthArrow.gif");
            }
            return _$8;
        }

        public void setCreateNorthArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$8 = cursor;
        }

        public static Cursor getCreateMapScale() {
            if (_$7 == null) {
                _$7 = Cursors._$1(_$1 + "createMapScale.gif");
            }
            return _$7;
        }

        public static Cursor getCreateGeoLegend() {
            if (_$6 == null) {
                _$6 = Cursors._$1(_$1 + "createRectangle.gif");
            }
            return _$6;
        }

        public void setCreateGeoLegend(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$6 = cursor;
        }

        public void setCreateMapScale(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$7 = cursor;
        }

        public static Cursor getCreateBSpline() {
            if (_$5 == null) {
                _$5 = Cursors._$1(_$1 + "createBSpline.gif");
            }
            return _$5;
        }

        public void setCreateBSpline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$5 = cursor;
        }

        public static Cursor getCreateFreePolyline() {
            if (_$4 == null) {
                _$4 = Cursors._$1(_$1 + "createFreePolyline.gif");
            }
            return _$4;
        }

        public void setCreateFreePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$4 = cursor;
        }

        public static Cursor getCreateCardinal() {
            if (_$3 == null) {
                _$3 = Cursors._$1(_$1 + "createCardinal.gif");
            }
            return _$3;
        }

        public void setCreateCardinal(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            _$3 = cursor;
        }

        public static Cursor getCreateMap() {
            if (_$2 == null) {
                _$2 = Cursors._$1(_$1 + "createMap.gif");
            }
            return _$2;
        }

        static {
            _$1 = "";
        }
    }
}

