/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.RasterClipFileType;
import com.supermap.analyst.spatialanalyst.RasterClipNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class RasterClip {
    private static License _$2;
    private static transient Vector _$1;

    private RasterClip() {
    }

    @Deprecated
    public static Dataset clipDatasetRaster(Dataset dataset, GeoRegion geoRegion, boolean bl, boolean bl2, Datasource datasource, String string) {
        return RasterClip.clip(dataset, geoRegion, bl, bl2, datasource, string);
    }

    public static Dataset clip(Dataset dataset, GeoRegion geoRegion, boolean bl, boolean bl2, Datasource datasource, String string) {
        RasterClip._$1();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        if (geoRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l4 = RasterClipNative.jni_ClipDatasetRaster(l, l3, l2, string, bl, bl2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        if (l4 != 0L) {
            if (dataset.getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    public static boolean clip(DatasetImage datasetImage, GeoRegion geoRegion, boolean bl, String string, RasterClipFileType rasterClipFileType) {
        RasterClip._$1();
        if (datasetImage == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetImage) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (geoRegion == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
            String string3 = InternalResource.loadString("userRegion", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("targetFileName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!RasterClip._$1(string)) {
            String string5 = InternalResource.loadString("targetFileName:" + string, "Global_PathIsNotValid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = "";
        if (rasterClipFileType.equals((Object)RasterClipFileType.TIF)) {
            string6 = ".tif";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.IMG)) {
            string6 = ".img";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.SIT)) {
            string6 = ".sit";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.BMP)) {
            string6 = ".bmp";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.JPG)) {
            string6 = ".jpg";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.PNG)) {
            string6 = ".png";
        } else if (rasterClipFileType.equals((Object)RasterClipFileType.GIF)) {
            string6 = ".gif";
        } else {
            String string7 = InternalResource.loadString("targetFileType:", "Global_EnumInvalidDerivedClass", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        string = RasterClip._$1(string, string6);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetImage);
        long l2 = 0L;
        if (geoRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = InternalEnum.getUGCValue(rasterClipFileType);
        int n2 = RasterClipNative.jni_ClipDatasetRasterImage(l, l2, string, n, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return n2 > 0;
    }

    public static boolean split(Dataset dataset, GeoLine geoLine, Datasource datasource, String string, String string2) {
        RasterClip._$1();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string3 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (dataset.getType() != DatasetType.IMAGE && dataset.getType() != DatasetType.GRID) {
            String string4 = InternalResource.loadString("sourceDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetLeftRasterName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string7 = InternalResource.loadString("targetRightDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (string2 == string) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        long[] lArray = RasterClipNative.jni_Split(l, l3, l2, string, string2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        if (lArray != null && lArray.length == 2) {
            DatasetImage datasetImage;
            DatasetImage datasetImage2;
            if (dataset.getType() == DatasetType.IMAGE) {
                datasetImage2 = InternalDatasetImage.createInstance(lArray[0], datasource);
                datasetImage = InternalDatasetImage.createInstance(lArray[1], datasource);
                if (datasetImage2 != null && datasetImage != null) {
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage2);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
                    return true;
                }
            }
            if (dataset.getType() == DatasetType.GRID) {
                datasetImage2 = InternalDatasetGrid.createInstance(lArray[0], datasource);
                datasetImage = InternalDatasetGrid.createInstance(lArray[1], datasource);
                if (datasetImage2 != null && datasetImage != null) {
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage2);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
                    return true;
                }
            }
        }
        return false;
    }

    private static String _$1(String string, String string2) {
        String string3 = null;
        if (string.toLowerCase().endsWith(string2)) {
            int n = string.toLowerCase().lastIndexOf(string2);
            string3 = string.substring(0, n) + string2;
        } else {
            string3 = string + string2;
        }
        return string3;
    }

    private static boolean _$1(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "RasterClip";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        RasterClip.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

