/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CalculationTerrainNative;
import com.supermap.analyst.spatialanalyst.CutFillResult;
import com.supermap.analyst.spatialanalyst.ExtremumInfo;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProfileResult;
import com.supermap.analyst.spatialanalyst.ShadowMode;
import com.supermap.analyst.spatialanalyst.SlopeType;
import com.supermap.analyst.spatialanalyst.TerrainAnalystSetting;
import com.supermap.data.ColorDictionary;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

public class CalculationTerrain {
    private static License _$3;
    private static transient Vector _$2;
    private static TerrainAnalystSetting _$1;

    private CalculationTerrain() {
        _$1 = null;
    }

    public static TerrainAnalystSetting getAnalystSetting() {
        return _$1;
    }

    public static void setAnalystSetting(TerrainAnalystSetting terrainAnalystSetting) {
        if (terrainAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new TerrainAnalystSetting();
        }
        _$1.setBounds(terrainAnalystSetting.getBounds());
        _$1.setBoundsType(terrainAnalystSetting.getBoundsType());
        _$1.setCellSizeType(terrainAnalystSetting.getCellSizeType());
        _$1.setCellSize(terrainAnalystSetting.getCellSize());
        _$1.setOutputDatasource(terrainAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(terrainAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(terrainAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(terrainAnalystSetting.getValidRegion());
        _$1.setShowProgress(terrainAnalystSetting.isShowProgress());
    }

    public static DatasetGrid calculateSlope(DatasetGrid datasetGrid, SlopeType slopeType, double d, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(slopeType);
        long l3 = CalculationTerrainNative.jni_CalculateSlope(l, n, d, l2, string, bl);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid calculateAspect(DatasetGrid datasetGrid, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = CalculationTerrainNative.jni_CalculateAspect(l, l2, string, bl);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid calculateHillShade(DatasetGrid datasetGrid, ShadowMode shadowMode, double d, double d2, double d3, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (d2 > 90.0 || d2 < 0.0) {
            String string6 = InternalResource.loadString("altitude", "Value Should_Between_0_And_90", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(shadowMode);
        long l3 = CalculationTerrainNative.jni_CalculateHillShade(l, n, d, d2, d3, l2, string, bl);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid datasetGrid, Colors colors, double d, Datasource datasource, String string) {
        CalculationTerrain._$1();
        Datasource datasource2 = datasource;
        String string2 = string;
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            datasource2 = _$1.getOutputDatasource();
        }
        if (string2 == null) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (_$1 != null && _$1.getGridOutputNamePrefix() != null) {
            string2 = _$1.getGridOutputNamePrefix() + string2;
        }
        if (!datasource2.getDatasets().isAvailableDatasetName(string2)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource2);
        long l4 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, 0L, l3, string2, false);
        DatasetImage datasetImage = null;
        if (l4 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l4, datasource2);
            InternalDatasets.add(datasource2.getDatasets(), (Dataset)datasetImage);
        }
        return datasetImage;
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid datasetGrid, Colors colors, Color color, double d, Datasource datasource, String string) {
        return CalculationTerrain.calculateOrthoImage(datasetGrid, colors, color, datasource, string);
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid datasetGrid, Colors colors, Color color, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        Colors colors2 = new Colors();
        colors2.add(color);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors2);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l5 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, l3, l4, string, bl);
        DatasetImage datasetImage = null;
        if (l5 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l5, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors2);
        return datasetImage;
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid datasetGrid, ColorDictionary colorDictionary, Color color, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = CalculationTerrainNative.jni_CalculateOrthoImageColorDictionary(l, l2, color.getRGB(), l3, string, bl);
        DatasetImage datasetImage = null;
        if (l4 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colorDictionary);
        return datasetImage;
    }

    @Deprecated
    public static ProfileResult calculateProfile(DatasetGrid datasetGrid, GeoLine geoLine, double d) {
        return CalculationTerrain.calculateProfile(datasetGrid, geoLine);
    }

    public static ProfileResult calculateProfile(DatasetGrid datasetGrid, GeoLine geoLine) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        double d = 0.0;
        long[] lArray = CalculationTerrainNative.jni_CalculateProfile(l, l2, d);
        ProfileResult profileResult = null;
        if (lArray != null && lArray.length == 2) {
            Geometry geometry = null;
            geometry = InternalGeometry.createInstance(lArray[0]);
            Geometry geometry2 = null;
            geometry2 = InternalGeometry.createInstance(lArray[1]);
            profileResult = new ProfileResult((GeoLine)geometry, (GeoLine)geometry2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        return profileResult;
    }

    public static ExtremumInfo findExtremum(DatasetGrid datasetGrid, GeoRegion geoRegion, long l) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l3 = 0L;
        if (geoRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        double[] dArray = CalculationTerrainNative.jni_FindExtremum(l2, l3, l);
        boolean bl = false;
        if (dArray[0] == 1.0) {
            bl = true;
        }
        ExtremumInfo extremumInfo = null;
        if (bl) {
            int n;
            int n2 = (int)dArray[1];
            int n3 = (int)dArray[2];
            Point2D point2D = new Point2D();
            Point2Ds point2Ds = new Point2Ds();
            Point2Ds point2Ds2 = new Point2Ds();
            for (n = 0; n < n2; ++n) {
                point2D.setX(dArray[5 + 2 * n]);
                point2D.setY(dArray[5 + 2 * n + 1]);
                point2Ds.add(point2D);
            }
            n = 5 + n2 * 2;
            for (int i = 0; i < n3; ++i) {
                point2D.setX(dArray[n + 2 * i]);
                point2D.setY(dArray[n + 2 * i + 1]);
                point2Ds2.add(point2D);
            }
            extremumInfo = new ExtremumInfo(dArray[3], dArray[4], point2Ds, point2Ds2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return extremumInfo;
    }

    public static GeoRegion flood(DatasetGrid datasetGrid, double d, GeoRegion geoRegion) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l2 = 0L;
        if (geoRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        long l3 = CalculationTerrainNative.jni_Flood(l, d, l2, bl);
        GeoRegion geoRegion2 = null;
        if (l3 != 0L) {
            geoRegion2 = (GeoRegion)InternalGeometry.createInstance(l3);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return geoRegion2;
    }

    public static CutFillResult cutFill(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("preCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid2 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2) == 0L) {
            String string3 = InternalResource.loadString("afterCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == string) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFill(l, l2, l3, string, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid3);
        }
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid datasetGrid, GeoRegion geoRegion, double d, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = 0L;
        if (geoRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFillSelect(l2, l, d, l3, string, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid datasetGrid, GeoRegion geoRegion, double d) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (geoRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        double[] dArray = new double[5];
        boolean bl2 = CalculationTerrainNative.jni_CutFillSelectNoGridResult(l2, l, d, dArray, bl);
        CutFillResult cutFillResult = null;
        if (bl2) {
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], null);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid datasetGrid, GeoLine3D geoLine3D, double d, boolean bl, Datasource datasource, String string) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (geoLine3D == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine3D) == 0L) {
            String string3 = InternalResource.loadString("line3D", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == string) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl2 = false;
        if (null != _$1) {
            bl2 = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine3D);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFillIncline(l, l2, d, bl, l3, string, dArray, bl2);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine3D);
        return cutFillResult;
    }

    public static double cutFill(DatasetGrid datasetGrid, double d, boolean bl) {
        return CalculationTerrain.cutFill(datasetGrid, d, bl, null);
    }

    public static double cutFill(DatasetGrid datasetGrid, double d, boolean bl, GeoRegion geoRegion) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("volume", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (geoRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        return CalculationTerrainNative.jni_CutFillByVolume(l2, d, bl, l);
    }

    public static double computeSurfaceDistance(DatasetGrid datasetGrid, GeoLine geoLine) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geoLine == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine) == 0L) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        double d = CalculationTerrainNative.jni_ComputeSurfaceDistance(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        return d;
    }

    public static double computeSurfaceArea(DatasetGrid datasetGrid, GeoRegion geoRegion) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = 0L;
        if (geoRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        double d = CalculationTerrainNative.jni_ComputeSurfaceArea(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return d;
    }

    public static double computeSurfaceVolume(DatasetGrid datasetGrid, GeoRegion geoRegion, double d) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = 0L;
        if (geoRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        double d2 = CalculationTerrainNative.jni_ComputeSurfaceVolume(l, l2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return d2;
    }

    public static double computePointSlope(DatasetGrid datasetGrid, Point2D point2D, SlopeType slopeType, double d) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        int n = InternalEnum.getUGCValue(slopeType);
        return CalculationTerrainNative.jni_ComputePointSlope(l, point2D.getX(), point2D.getY(), n, d);
    }

    public static double computePointAspect(DatasetGrid datasetGrid, Point2D point2D) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        return CalculationTerrainNative.jni_ComputePointAspect(l, point2D.getX(), point2D.getY());
    }

    public static DatasetGrid calculateCurvature(DatasetGrid datasetGrid, double d, Datasource datasource, String string, String string2, String string3) {
        CalculationTerrain._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string4 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == string) {
            String string6 = InternalResource.loadString("curvatureGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("averageCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (string2 != null && !string2.isEmpty() && !datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string8 = InternalResource.loadString("profileCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string3 != null && !string3.isEmpty() && !datasource.getDatasets().isAvailableDatasetName(string3)) {
            String string9 = InternalResource.loadString("planCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long[] lArray = CalculationTerrainNative.jni_CalculateCurvature(l, d, l2, string, string2, string3, bl);
        DatasetGrid datasetGrid2 = null;
        if (lArray != null && lArray.length == 3 && lArray[0] != 0L) {
            DatasetGrid datasetGrid3;
            datasetGrid2 = InternalDatasetGrid.createInstance(lArray[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            if (lArray[1] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
            if (lArray[2] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
        }
        return datasetGrid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$3;
        synchronized (object) {
            n = _$3.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "CalculationTerrain";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        CalculationTerrain.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$3 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

