/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.formula;

import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

public class CalculateMortgage
implements FreeRefFunction {
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        double result;
        if (args.length != 3) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval v1 = OperandResolver.getSingleValue((ValueEval)args[0], (int)ec.getRowIndex(), (int)ec.getColumnIndex());
            ValueEval v2 = OperandResolver.getSingleValue((ValueEval)args[1], (int)ec.getRowIndex(), (int)ec.getColumnIndex());
            ValueEval v3 = OperandResolver.getSingleValue((ValueEval)args[2], (int)ec.getRowIndex(), (int)ec.getColumnIndex());
            double principal = OperandResolver.coerceValueToDouble((ValueEval)v1);
            double rate = OperandResolver.coerceValueToDouble((ValueEval)v2);
            double years = OperandResolver.coerceValueToDouble((ValueEval)v3);
            result = this.calculateMortgagePayment(principal, rate, years);
            System.out.println("Result = " + result);
            this.checkValue(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    public double calculateMortgagePayment(double p, double r, double y) {
        double i = r / 12.0;
        double n = y * 12.0;
        double principalAndInterest = p * (i * Math.pow(1.0 + i, n) / (Math.pow(1.0 + i, n) - 1.0));
        return principalAndInterest;
    }

    private void checkValue(double result) throws EvaluationException {
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    }
}

