/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.config.annotation.CorsRegistration;

public class CorsConfigurer {
    private final List<CorsRegistration> registrations = new ArrayList<CorsRegistration>();

    public CorsRegistration enableCors(String ... pathPatterns) {
        CorsRegistration registration = new CorsRegistration(pathPatterns);
        this.registrations.add(registration);
        return registration;
    }

    protected Map<String, CorsConfiguration> getCorsConfigurations() {
        LinkedHashMap<String, CorsConfiguration> configs = new LinkedHashMap<String, CorsConfiguration>(this.registrations.size());
        for (CorsRegistration registration : this.registrations) {
            for (String pathPattern : registration.getPathPatterns()) {
                configs.put(pathPattern, registration.getCorsConfiguration());
            }
        }
        return configs;
    }
}

