/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import junit.framework.TestCase;
import org.json.JSONException;
import org.json.XMLTokener;

public class TestXMLTokener
extends TestCase {
    private XMLTokener xmltokener;

    public void testNextContent() {
        try {
            this.xmltokener = new XMLTokener("< abc><de&nbsp;f/></abc>");
            TestXMLTokener.assertEquals((Object)Character.valueOf('<'), (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals((Object)"abc>", (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals((Object)Character.valueOf('<'), (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals((Object)"de&nbsp;f/>", (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals((Object)Character.valueOf('<'), (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals((Object)"/abc>", (Object)this.xmltokener.nextContent());
            TestXMLTokener.assertEquals(null, (Object)this.xmltokener.nextContent());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextCdata() {
        try {
            this.xmltokener = new XMLTokener("<[CDATA[<abc/>]]>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((Object)"CDATA", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((String)"<abc/>", (String)this.xmltokener.nextCDATA());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextCdata_BrokenCdata1() {
        try {
            this.xmltokener = new XMLTokener("<[CDATA[<abc/>]><abc>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((Object)"CDATA", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            this.xmltokener.nextCDATA();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unclosed CDATA at 22 [character 23 line 1]", (String)e.getMessage());
        }
    }

    public void testNextCdata_BrokenCdata2() {
        try {
            this.xmltokener = new XMLTokener("<[CDATA[<abc/>]]<abc>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((Object)"CDATA", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            this.xmltokener.nextCDATA();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unclosed CDATA at 22 [character 23 line 1]", (String)e.getMessage());
        }
    }

    public void testNextCdata_BrokenCdata3() {
        try {
            this.xmltokener = new XMLTokener("<[CDATA[<abc/>]]<abc>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((Object)"CDATA", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            this.xmltokener.nextCDATA();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unclosed CDATA at 22 [character 23 line 1]", (String)e.getMessage());
        }
    }

    public void testNextCdata_BrokenCdata4() {
        try {
            this.xmltokener = new XMLTokener("<[CDATA[<abc/>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            TestXMLTokener.assertEquals((Object)"CDATA", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((char)'[', (char)this.xmltokener.next('['));
            this.xmltokener.nextCDATA();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unclosed CDATA at 15 [character 16 line 1]", (String)e.getMessage());
        }
    }

    public void testNextEntity_Ampersand() {
        try {
            this.xmltokener = new XMLTokener("<&amp;>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'&', (char)this.xmltokener.next('&'));
            TestXMLTokener.assertEquals((Object)Character.valueOf('&'), (Object)this.xmltokener.nextEntity('&'));
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextEntity_NumberEntity() {
        try {
            this.xmltokener = new XMLTokener("<&#60;>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'&', (char)this.xmltokener.next('&'));
            TestXMLTokener.assertEquals((Object)"&#60;", (Object)this.xmltokener.nextEntity('&'));
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextEntity_BrokenEntity() {
        try {
            this.xmltokener = new XMLTokener("<&nbsp");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'&', (char)this.xmltokener.next('&'));
            TestXMLTokener.assertEquals((Object)"&#60;", (Object)this.xmltokener.nextEntity('&'));
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Missing ';' in XML entity: &nbsp at 7 [character 8 line 1]", (String)e.getMessage());
        }
    }

    public void testNextMeta_String() {
        try {
            this.xmltokener = new XMLTokener("<! \"metaString\">");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            TestXMLTokener.assertEquals((Object)true, (Object)this.xmltokener.nextMeta());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextMeta_OpenString() {
        try {
            this.xmltokener = new XMLTokener("<! \"metaString>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            this.xmltokener.nextMeta();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unterminated string at 16 [character 17 line 1]", (String)e.getMessage());
        }
    }

    public void testNextMeta_Symbols() {
        try {
            this.xmltokener = new XMLTokener("<! <>/=!?>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            TestXMLTokener.assertEquals((Object)Character.valueOf('<'), (Object)this.xmltokener.nextMeta());
            TestXMLTokener.assertEquals((Object)Character.valueOf('>'), (Object)this.xmltokener.nextMeta());
            TestXMLTokener.assertEquals((Object)Character.valueOf('/'), (Object)this.xmltokener.nextMeta());
            TestXMLTokener.assertEquals((Object)Character.valueOf('='), (Object)this.xmltokener.nextMeta());
            TestXMLTokener.assertEquals((Object)Character.valueOf('!'), (Object)this.xmltokener.nextMeta());
            TestXMLTokener.assertEquals((Object)Character.valueOf('?'), (Object)this.xmltokener.nextMeta());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextMeta_Misshaped() {
        try {
            this.xmltokener = new XMLTokener("<!");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            this.xmltokener.nextMeta();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Misshaped meta tag at 3 [character 4 line 1]", (String)e.getMessage());
        }
    }

    public void testNextMeta_EndingWithBang() {
        try {
            this.xmltokener = new XMLTokener("<!data!");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            TestXMLTokener.assertEquals((Object)true, (Object)this.xmltokener.nextMeta());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextMeta_EndingWithSpace() {
        try {
            this.xmltokener = new XMLTokener("<!data ");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((char)'!', (char)this.xmltokener.next('!'));
            TestXMLTokener.assertEquals((Object)true, (Object)this.xmltokener.nextMeta());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_NormalTag() {
        try {
            this.xmltokener = new XMLTokener("<da ta>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((Object)"da", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((Object)"ta", (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((Object)Character.valueOf('>'), (Object)this.xmltokener.nextToken());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_TagWithBadCharacter() {
        try {
            this.xmltokener = new XMLTokener("<da<ta>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            this.xmltokener.nextToken();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Bad character in a name at 4 [character 5 line 1]", (String)e.getMessage());
        }
    }

    public void testNextToken_TagWithMisplacedLessThan() {
        try {
            this.xmltokener = new XMLTokener("<<data>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            this.xmltokener.nextToken();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Misplaced '<' at 2 [character 3 line 1]", (String)e.getMessage());
        }
    }

    public void testNextToken_MisshapedElement() {
        try {
            this.xmltokener = new XMLTokener("<");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            this.xmltokener.nextToken();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Misshaped element at 2 [character 3 line 1]", (String)e.getMessage());
        }
    }

    public void testNextToken_Symbols() {
        try {
            this.xmltokener = new XMLTokener("< /=!?");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((Object)Character.valueOf('/'), (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((Object)Character.valueOf('='), (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((Object)Character.valueOf('!'), (Object)this.xmltokener.nextToken());
            TestXMLTokener.assertEquals((Object)Character.valueOf('?'), (Object)this.xmltokener.nextToken());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_String() {
        try {
            this.xmltokener = new XMLTokener("<\"abc&amp;123\">");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((Object)"abc&123", (Object)this.xmltokener.nextToken());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_NoGreaterThan() {
        try {
            this.xmltokener = new XMLTokener("<abc123");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((Object)"abc123", (Object)this.xmltokener.nextToken());
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_UnterminatedString() {
        try {
            this.xmltokener = new XMLTokener("<\"abc123>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            this.xmltokener.nextToken();
            TestXMLTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestXMLTokener.assertEquals((String)"Unterminated string at 10 [character 11 line 1]", (String)e.getMessage());
        }
    }

    public void testSkipTo() {
        try {
            this.xmltokener = new XMLTokener("<abc123>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((boolean)true, (boolean)this.xmltokener.skipPast("c1"));
            TestXMLTokener.assertEquals((char)'2', (char)this.xmltokener.next('2'));
            TestXMLTokener.assertEquals((boolean)false, (boolean)this.xmltokener.skipPast("b1"));
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }

    public void testSkipTo_LongParameter() {
        try {
            this.xmltokener = new XMLTokener("<abc>");
            TestXMLTokener.assertEquals((char)'<', (char)this.xmltokener.next('<'));
            TestXMLTokener.assertEquals((boolean)false, (boolean)this.xmltokener.skipPast("abcdefghi"));
        }
        catch (JSONException e) {
            TestXMLTokener.fail((String)e.getMessage());
        }
    }
}

