/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.routing;

import java.util.ArrayList;
import java.util.Collection;
import org.smslib.AGateway;
import org.smslib.OutboundMessage;

public class Router {
    private ArrayList<AGateway> candidates = new ArrayList();
    private ArrayList<AGateway> allowed = new ArrayList();

    protected ArrayList<AGateway> getCandidates() {
        return this.candidates;
    }

    protected ArrayList<AGateway> getAllowed() {
        return this.allowed;
    }

    protected void preroute(OutboundMessage msg, Collection<AGateway> gateways) {
        for (AGateway gtw : gateways) {
            if (!gtw.isOutbound() || gtw.getStatus() != AGateway.GatewayStatuses.STARTED) continue;
            if (msg.getGatewayId().equalsIgnoreCase("*")) {
                this.getCandidates().add(gtw);
                continue;
            }
            if (!msg.getGatewayId().equalsIgnoreCase(gtw.getGatewayId())) continue;
            this.getCandidates().add(gtw);
        }
    }

    public Collection<AGateway> route(OutboundMessage msg, Collection<AGateway> gateways) {
        this.beginRouting();
        this.preroute(msg, gateways);
        this.customRouting(msg);
        return this.getAllowed();
    }

    public void customRouting(OutboundMessage msg) {
        this.getAllowed().addAll(this.getCandidates());
    }

    protected final void beginRouting() {
        this.getCandidates().clear();
        this.getAllowed().clear();
    }

    protected final void finishRouting() {
        this.getCandidates().clear();
        this.getAllowed().clear();
    }
}

