/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.JobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.runtime.Job;

public class JobEntityManager
extends AbstractManager {
    public void send(MessageEntity message) {
        message.insert();
        this.hintJobExecutor(message);
    }

    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        if (duedate == null) {
            throw new ActivitiIllegalArgumentException("duedate is null");
        }
        timer.insert();
        this.pokeJobExecutor(timer);
    }

    public void pokeJobExecutor(JobEntity job) {
        if (job.getDuedate().getTime() <= Context.getProcessEngineConfiguration().getClock().getCurrentTime().getTime()) {
            this.hintJobExecutor(job);
        }
    }

    protected void hintJobExecutor(JobEntity job) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        JobAddedNotification transactionListener = new JobAddedNotification(jobExecutor);
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerEntity> timers = Context.getCommandContext().getJobEntityManager().findTimersByExecutionId(execution.getId());
        for (TimerEntity timer : timers) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timer));
            }
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbSqlSession().selectOne("selectJob", jobId);
    }

    public List<JobEntity> findNextJobsToExecute(Page page) {
        Date now = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextJobsToExecute", now, page);
    }

    public List<Job> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findExclusiveJobsToExecute(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", processInstanceId);
        params.put("now", Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        return this.getDbSqlSession().selectList("selectExclusiveJobsToExecute", params);
    }

    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbSqlSession().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<Job> findJobsByConfiguration(String jobHandlerType, String jobHandlerConfiguration) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handlerType", jobHandlerType);
        params.put("handlerConfiguration", jobHandlerConfiguration);
        return this.getDbSqlSession().selectList("selectJobsByConfiguration", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }
}

