/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

import java.util.Arrays;

public final class Galois {
    public static final int POLYNOMIAL = 29;
    private static final Galois instance = new Galois();
    private int[] expTbl = new int[510];
    private int[] logTbl = new int[256];

    private Galois() {
        this.initGaloisTable();
    }

    public static Galois getInstance() {
        return instance;
    }

    private void initGaloisTable() {
        int d = 1;
        int i = 0;
        while (i < 255) {
            int n = d;
            this.expTbl[255 + i] = n;
            this.expTbl[i] = n;
            this.logTbl[d] = i;
            if (((d <<= 1) & 0x100) != 0) {
                d = (d ^ 0x1D) & 0xFF;
            }
            ++i;
        }
    }

    public int toExp(int a) {
        return this.expTbl[a];
    }

    public int toLog(int a) {
        return this.logTbl[a];
    }

    public int toPos(int length, int a) {
        return length - 1 - this.logTbl[a];
    }

    public int mul(int a, int b) {
        return a == 0 || b == 0 ? 0 : this.expTbl[this.logTbl[a] + this.logTbl[b]];
    }

    public int mulExp(int a, int b) {
        return a == 0 ? 0 : this.expTbl[this.logTbl[a] + b];
    }

    public int div(int a, int b) {
        return a == 0 ? 0 : this.expTbl[this.logTbl[a] - this.logTbl[b] + 255];
    }

    public int divExp(int a, int b) {
        return a == 0 ? 0 : this.expTbl[this.logTbl[a] - b + 255];
    }

    public int inv(int a) {
        return this.expTbl[255 - this.logTbl[a]];
    }

    public void mulPoly(int[] seki, int[] a, int[] b) {
        Arrays.fill(seki, 0);
        int ia = 0;
        while (ia < a.length) {
            if (a[ia] != 0) {
                int loga = this.logTbl[a[ia]];
                int ib2 = Math.min(b.length, seki.length - ia);
                int ib = 0;
                while (ib < ib2) {
                    if (b[ib] != 0) {
                        int n = ia + ib;
                        seki[n] = seki[n] ^ this.expTbl[loga + this.logTbl[b[ib]]];
                    }
                    ++ib;
                }
            }
            ++ia;
        }
    }

    public boolean calcSyndrome(int[] data, int length, int[] syn) {
        int hasErr = 0;
        int i = 0;
        while (i < syn.length) {
            int wk = 0;
            int idx = 0;
            while (idx < length) {
                wk = data[idx] ^ (wk == 0 ? 0 : this.expTbl[this.logTbl[wk] + i]);
                ++idx;
            }
            syn[i] = wk;
            hasErr |= wk;
            ++i;
        }
        return hasErr == 0;
    }
}

