// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Notice of modification to part of a document. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/text.html#edef-ins">INS</A>
  and 
    <A  href="http://www.w3.org/TR/REC-html40/struct/text.html#edef-del">DEL</A>
  element definitions in HTML 4.0. 
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cite><CODE>&nbsp;cite</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCite()'>getCite</a>
<a href='#setCite(java.lang.String)'>setCite</a>
</TD>
<TD>
  <P>A URI designating a document that describes the reason for the change. See the 
    <A  href="http://www.w3.org/TR/REC-html40/">cite attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-dateTime><CODE>&nbsp;dateTime</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDateTime()'>getDateTime</a>
<a href='#setDateTime(java.lang.String)'>setDateTime</a>
</TD>
<TD>
  <P>The date and time of the change. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/text.html#adef-datetime">datetime attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLModElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-cite>cite</a></code> property.
	 */
	void setCite (String cite);

	/**
	 * Returns the value of the <code><a href=#att-cite>cite</a></code> property.
	*/
	String getCite ();


	/** Assigns the value of the <code><a href=#att-dateTime>dateTime</a></code> property.
	 */
	void setDateTime (String dateTime);

	/**
	 * Returns the value of the <code><a href=#att-dateTime>dateTime</a></code> property.
	*/
	String getDateTime ();


}
