/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerMethodSelector {
    public static Set<Method> selectMethods(Class<?> handlerType, final ReflectionUtils.MethodFilter handlerMethodFilter) {
        final LinkedHashSet<Method> handlerMethods = new LinkedHashSet<Method>();
        LinkedHashSet<Class> handlerTypes = new LinkedHashSet<Class>();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(handlerType)) {
            handlerTypes.add(handlerType);
            specificHandlerType = handlerType;
        }
        handlerTypes.addAll((Collection)Arrays.asList(handlerType.getInterfaces()));
        for (Class currentHandlerType : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : currentHandlerType;
            ReflectionUtils.doWithMethods((Class)currentHandlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (handlerMethodFilter.matches(specificMethod) && (bridgedMethod == specificMethod || !handlerMethodFilter.matches(bridgedMethod))) {
                        handlerMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return handlerMethods;
    }
}

