/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    protected String processDefinitonKey;
    private List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    private List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();
    private Expression processDefinitionExpression;

    public CallActivityBehavior(String processDefinitionKey) {
        this.processDefinitonKey = processDefinitionKey;
    }

    public CallActivityBehavior(Expression processDefinitionExpression) {
        this.processDefinitionExpression = processDefinitionExpression;
    }

    public void addDataInputAssociation(AbstractDataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        String processDefinitonKey = this.processDefinitonKey;
        if (this.processDefinitionExpression != null) {
            processDefinitonKey = (String)this.processDefinitionExpression.getValue(execution);
        }
        ProcessDefinitionEntity processDefinition = null;
        processDefinition = execution.getTenantId() == null || "".equals(execution.getTenantId()) ? Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(processDefinitonKey) : Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitonKey, execution.getTenantId());
        PvmProcessInstance subProcessInstance = execution.createSubProcessInstance(processDefinition);
        for (AbstractDataAssociation dataInputAssociation : this.dataInputAssociations) {
            Object value = null;
            value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue(execution) : execution.getVariable(dataInputAssociation.getSource());
            subProcessInstance.setVariable(dataInputAssociation.getTarget(), value);
        }
        subProcessInstance.start();
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (AbstractDataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue(subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }
}

