/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.test.mock.ActivitiMockSupport;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class ActivitiRule
implements TestRule {
    protected String configurationResource = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected ActivitiMockSupport mockSupport;

    public ActivitiRule() {
    }

    public ActivitiRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ActivitiRule(ProcessEngine processEngine) {
        this.setProcessEngine(processEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                ActivitiRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    ActivitiRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    ActivitiRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    ActivitiRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    ActivitiRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        if (this.processEngineConfiguration == null) {
            this.initializeServices();
        }
        if (this.mockSupport == null) {
            this.initializeMockSupport();
        }
        this.configureProcessEngine();
        try {
            TestHelper.annotationMockSupportSetup(Class.forName(description.getClassName()), description.getMethodName(), this.mockSupport);
        }
        catch (ClassNotFoundException e) {
            throw new ActivitiException("Programmatic error: could not instantiate " + description.getClassName(), e);
        }
        try {
            this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new ActivitiException("Programmatic error: could not instantiate " + description.getClassName(), e);
        }
    }

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.processEngineConfiguration = this.processEngine.getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
    }

    protected void initializeMockSupport() {
        if (ActivitiMockSupport.isMockSupportPossible(this.processEngine)) {
            this.mockSupport = new ActivitiMockSupport(this.processEngine);
        }
    }

    protected void configureProcessEngine() {
    }

    protected void finished(Description description) {
        try {
            TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new ActivitiException("Programmatic error: could not instantiate " + description.getClassName(), e);
        }
        this.processEngineConfiguration.getClock().reset();
        if (this.mockSupport != null) {
            TestHelper.annotationMockSupportTeardown(this.mockSupport);
        }
    }

    public void setCurrentTime(Date currentTime) {
        this.processEngineConfiguration.getClock().setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.initializeServices();
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoricDataService(HistoryService historicDataService) {
        this.historyService = historicDataService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ActivitiMockSupport getMockSupport() {
        return this.mockSupport;
    }

    public ActivitiMockSupport mockSupport() {
        return this.mockSupport;
    }
}

