/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.history.ProcessInstanceHistoryLog;
import org.activiti.engine.history.ProcessInstanceHistoryLogQuery;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.ProcessInstanceHistoryLogImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.task.Comment;

public class ProcessInstanceHistoryLogQueryImpl
implements ProcessInstanceHistoryLogQuery,
Command<ProcessInstanceHistoryLog> {
    protected CommandExecutor commandExecutor;
    protected String processInstanceId;
    protected boolean includeTasks;
    protected boolean includeActivities;
    protected boolean includeVariables;
    protected boolean includeComments;
    protected boolean includeVariableUpdates;
    protected boolean includeFormProperties;

    public ProcessInstanceHistoryLogQueryImpl(CommandExecutor commandExecutor, String processInstanceId) {
        this.commandExecutor = commandExecutor;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeTasks() {
        this.includeTasks = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeComments() {
        this.includeComments = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeActivities() {
        this.includeActivities = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeVariables() {
        this.includeVariables = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeVariableUpdates() {
        this.includeVariableUpdates = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeFormProperties() {
        this.includeFormProperties = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLog singleResult() {
        return this.commandExecutor.execute(this);
    }

    @Override
    public ProcessInstanceHistoryLog execute(CommandContext commandContext) {
        HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInstanceId);
        if (historicProcessInstance == null) {
            return null;
        }
        ProcessInstanceHistoryLogImpl processInstanceHistoryLog = new ProcessInstanceHistoryLogImpl(historicProcessInstance);
        if (this.includeTasks) {
            List<HistoricTaskInstance> tasks = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(new HistoricTaskInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId));
            processInstanceHistoryLog.addHistoricData(tasks);
        }
        if (this.includeActivities) {
            List<HistoricActivityInstance> activities = commandContext.getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByQueryCriteria(new HistoricActivityInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId), null);
            processInstanceHistoryLog.addHistoricData(activities);
        }
        if (this.includeVariables) {
            List<HistoricVariableInstance> variables = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByQueryCriteria(new HistoricVariableInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId), null);
            processInstanceHistoryLog.addHistoricData(variables);
        }
        if (this.includeComments) {
            List<Comment> comments = commandContext.getCommentEntityManager().findCommentsByProcessInstanceId(this.processInstanceId);
            processInstanceHistoryLog.addHistoricData(comments);
        }
        if (this.includeVariableUpdates) {
            List<HistoricDetail> variableUpdates = commandContext.getHistoricDetailEntityManager().findHistoricDetailsByQueryCriteria(new HistoricDetailQueryImpl(this.commandExecutor).variableUpdates(), null);
            processInstanceHistoryLog.addHistoricData(variableUpdates);
        }
        if (this.includeFormProperties) {
            List<HistoricDetail> formProperties = commandContext.getHistoricDetailEntityManager().findHistoricDetailsByQueryCriteria(new HistoricDetailQueryImpl(this.commandExecutor).formProperties(), null);
            processInstanceHistoryLog.addHistoricData(formProperties);
        }
        processInstanceHistoryLog.orderHistoricData();
        return processInstanceHistoryLog;
    }
}

