// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Script statements. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/scripts.html#edef-SCRIPT">SCRIPT element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-text><CODE>&nbsp;text</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getText()'>getText</a>
<a href='#setText(java.lang.String)'>setText</a>
</TD>
<TD>
  <P>The script content of the element. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-htmlFor><CODE>&nbsp;htmlFor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHtmlFor()'>getHtmlFor</a>
<a href='#setHtmlFor(java.lang.String)'>setHtmlFor</a>
</TD>
<TD>
  <P>
    <emph>Reserved for future use.</emph> 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-event><CODE>&nbsp;event</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getEvent()'>getEvent</a>
<a href='#setEvent(java.lang.String)'>setEvent</a>
</TD>
<TD>
  <P>
    <emph>Reserved for future use.</emph> 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-charset><CODE>&nbsp;charset</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCharset()'>getCharset</a>
<a href='#setCharset(java.lang.String)'>setCharset</a>
</TD>
<TD>
  <P>The character encoding of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-charset">charset attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-defer><CODE>&nbsp;defer</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDefer()'>getDefer</a>
<a href='#setDefer(java.lang.String)'>setDefer</a>
</TD>
<TD>
  <P>Indicates that the user agent can defer processing of the script. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/scripts.html#adef-defer">defer attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-src><CODE>&nbsp;src</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSrc()'>getSrc</a>
<a href='#setSrc(java.lang.String)'>setSrc</a>
</TD>
<TD>
  <P>URI designating an external script. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/scripts.html#adef-src-SCRIPT">src attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>The content type of the script language. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/scripts.html#adef-type-SCRIPT">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLScriptElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-text>text</a></code> property.
	 */
	void setText (String text);

	/**
	 * Returns the value of the <code><a href=#att-text>text</a></code> property.
	*/
	String getText ();


	/** Assigns the value of the <code><a href=#att-htmlFor>htmlFor</a></code> property.
	 */
	void setHtmlFor (String htmlFor);

	/**
	 * Returns the value of the <code><a href=#att-htmlFor>htmlFor</a></code> property.
	*/
	String getHtmlFor ();


	/** Assigns the value of the <code><a href=#att-event>event</a></code> property.
	 */
	void setEvent (String event);

	/**
	 * Returns the value of the <code><a href=#att-event>event</a></code> property.
	*/
	String getEvent ();


	/** Assigns the value of the <code><a href=#att-charset>charset</a></code> property.
	 */
	void setCharset (String charset);

	/**
	 * Returns the value of the <code><a href=#att-charset>charset</a></code> property.
	*/
	String getCharset ();


	/** Assigns the value of the <code><a href=#att-defer>defer</a></code> property.
	 */
	void setDefer (boolean defer);

	/**
	 * Returns the value of the <code><a href=#att-defer>defer</a></code> property.
	*/
	boolean getDefer ();


	/** Assigns the value of the <code><a href=#att-src>src</a></code> property.
	 */
	void setSrc (String src);

	/**
	 * Returns the value of the <code><a href=#att-src>src</a></code> property.
	*/
	String getSrc ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


}
