// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>A selectable choice. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-OPTION">OPTION element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-form><CODE>&nbsp;form</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForm()'>getForm</a>
</TD>
<TD>
  <P>Returns the 
    <code>FORM</code> element containing this control. Returns null if this control is not within the context of a form. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-defaultSelected><CODE>&nbsp;defaultSelected</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDefaultSelected()'>getDefaultSelected</a>
<a href='#setDefaultSelected(java.lang.String)'>setDefaultSelected</a>
</TD>
<TD>
  <P>Stores the initial value of the 
    <code>selected</code> attribute. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-text><CODE>&nbsp;text</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getText()'>getText</a>
</TD>
<TD>
  <P>The text contained within the option element. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-index><CODE>&nbsp;index</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getIndex()'>getIndex</a>
<a href='#setIndex(java.lang.String)'>setIndex</a>
</TD>
<TD>
  <P>The index of this 
    <code>OPTION</code> in its parent 
    <code>SELECT</code>. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-disabled><CODE>&nbsp;disabled</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDisabled()'>getDisabled</a>
<a href='#setDisabled(java.lang.String)'>setDisabled</a>
</TD>
<TD>
  <P>The control is unavailable in this context. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">disabled attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-label><CODE>&nbsp;label</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLabel()'>getLabel</a>
<a href='#setLabel(java.lang.String)'>setLabel</a>
</TD>
<TD>
  <P>Option label for use in hierarchical menus. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-label-OPTION">label attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-selected><CODE>&nbsp;selected</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSelected()'>getSelected</a>
</TD>
<TD>
  <P>Means that this option is initially selected. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-selected">selected attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-value><CODE>&nbsp;value</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValue()'>getValue</a>
<a href='#setValue(java.lang.String)'>setValue</a>
</TD>
<TD>
  <P>The current form control value. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-OPTION">value attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLOptionElement
extends HTMLElement
{
	/**
	 * Returns the value of the <code><a href=#att-form>form</a></code> property.
	*/
	HTMLFormElement getForm ();


	/** Assigns the value of the <code><a href=#att-defaultSelected>defaultSelected</a></code> property.
	 */
	void setDefaultSelected (boolean defaultSelected);

	/**
	 * Returns the value of the <code><a href=#att-defaultSelected>defaultSelected</a></code> property.
	*/
	boolean getDefaultSelected ();


	/**
	 * Returns the value of the <code><a href=#att-text>text</a></code> property.
	*/
	String getText ();


	/** Assigns the value of the <code><a href=#att-index>index</a></code> property.
	 */
	void setIndex (int index);

	/**
	 * Returns the value of the <code><a href=#att-index>index</a></code> property.
	*/
	int getIndex ();


	/** Assigns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	 */
	void setDisabled (boolean disabled);

	/**
	 * Returns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	*/
	boolean getDisabled ();


	/** Assigns the value of the <code><a href=#att-label>label</a></code> property.
	 */
	void setLabel (String label);

	/**
	 * Returns the value of the <code><a href=#att-label>label</a></code> property.
	*/
	String getLabel ();


	/**
	 * Returns the value of the <code><a href=#att-selected>selected</a></code> property.
	*/
	boolean getSelected ();


	/** Assigns the value of the <code><a href=#att-value>value</a></code> property.
	 */
	void setValue (String value);

	/**
	 * Returns the value of the <code><a href=#att-value>value</a></code> property.
	*/
	String getValue ();


}
