// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>This contains generic meta-information about the document. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#edef-META">META element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-content><CODE>&nbsp;content</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getContent()'>getContent</a>
<a href='#setContent(java.lang.String)'>setContent</a>
</TD>
<TD>
  <P>Associated information. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-content">content attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-httpEquiv><CODE>&nbsp;httpEquiv</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHttpEquiv()'>getHttpEquiv</a>
<a href='#setHttpEquiv(java.lang.String)'>setHttpEquiv</a>
</TD>
<TD>
  <P>HTTP response header name. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-http-equiv">http-equiv attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Meta information name. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-name-META">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-scheme><CODE>&nbsp;scheme</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getScheme()'>getScheme</a>
<a href='#setScheme(java.lang.String)'>setScheme</a>
</TD>
<TD>
  <P>Select form of content. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-scheme">scheme attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLMetaElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-content>content</a></code> property.
	 */
	void setContent (String content);

	/**
	 * Returns the value of the <code><a href=#att-content>content</a></code> property.
	*/
	String getContent ();


	/** Assigns the value of the <code><a href=#att-httpEquiv>httpEquiv</a></code> property.
	 */
	void setHttpEquiv (String httpEquiv);

	/**
	 * Returns the value of the <code><a href=#att-httpEquiv>httpEquiv</a></code> property.
	*/
	String getHttpEquiv ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-scheme>scheme</a></code> property.
	 */
	void setScheme (String scheme);

	/**
	 * Returns the value of the <code><a href=#att-scheme>scheme</a></code> property.
	*/
	String getScheme ();


}
