// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>An 
    <A HREF='HTMLDocument.html'><CODE>HTMLDocument</CODE></A> is the root of the HTML hierarchy and holds the entire content. Beside providing access to the hierarchy, it also provides some convenience methods for accessing certain sets of information from the document.
  
</P>
  <P>The following properties have been deprecated in favor of the corresponding ones for the BODY element:
</P>
  <UL>

    <LI>
      <P>alinkColor
</P>
    </LI>

    <LI>
      <P>background
</P>
    </LI>

    <LI>
      <P>bgColor
</P>
    </LI>

    <LI>
      <P>fgColor
</P>
    </LI>

    <LI>
      <P>linkColor
</P>
    </LI>

    <LI>
      <P>vlinkColor
</P>
    </LI>

  </UL>

  <P> 
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-title><CODE>&nbsp;title</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTitle()'>getTitle</a>
<a href='#setTitle(java.lang.String)'>setTitle</a>
</TD>
<TD>
  <P>The title of a document as specified by the 
    <code>TITLE</code>
element in the head of the document. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-referrer><CODE>&nbsp;referrer</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getReferrer()'>getReferrer</a>
</TD>
<TD>
  <P>Returns the URI of the page that linked to this page. The value is an empty string if the user navigated to the page directly (not through a link, but, for example, via a bookmark). 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-domain><CODE>&nbsp;domain</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDomain()'>getDomain</a>
</TD>
<TD>
  <P>The domain name of the server that served the document, or a null string if the server cannot be identified by a domain name. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-URL><CODE>&nbsp;URL</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getURL()'>getURL</a>
</TD>
<TD>
  <P>The complete URI of the document. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-body><CODE>&nbsp;body</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBody()'>getBody</a>
<a href='#setBody(java.lang.String)'>setBody</a>
</TD>
<TD>
  <P>The element that contains the content for the document. In documents with 
    <code>BODY</code> contents, returns the 
    <code>BODY</code>
element, and in frameset documents, this returns the outermost 
    <code>FRAMESET</code> element. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-images><CODE>&nbsp;images</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getImages()'>getImages</a>
</TD>
<TD>
  <P>A collection of all the 
    <code>IMG</code> elements in a document. The behavior is limited to 
    <code>IMG</code> elements for backwards compatibility. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-applets><CODE>&nbsp;applets</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getApplets()'>getApplets</a>
</TD>
<TD>
  <P>A collection of all the 
    <code>OBJECT</code> elements that include applets and 
    <code>APPLET</code> (
    <emph>deprecated</emph>) elements in a document. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-links><CODE>&nbsp;links</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLinks()'>getLinks</a>
</TD>
<TD>
  <P>A collection of all 
    <code>AREA</code> elements and anchor (
    <code>A</code>) elements in a document with a value for the 
    <code>href</code> attribute. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-forms><CODE>&nbsp;forms</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForms()'>getForms</a>
</TD>
<TD>
  <P>A collection of all the forms of a document. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-anchors><CODE>&nbsp;anchors</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAnchors()'>getAnchors</a>
</TD>
<TD>
  <P>A collection of all the anchor (
    <code>A</code>) elements in a document with a value for the 
    <code>name</code> attribute.
    <emph>Note.</emph> For reasons of backwards compatibility, the returned set of anchors only contains those anchors created with the 
    <code>name</code>  attribute, not those created with the 
    <code>id</code> attribute. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cookie><CODE>&nbsp;cookie</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCookie()'>getCookie</a>
<a href='#setCookie(java.lang.String)'>setCookie</a>
</TD>
<TD>
  <P>The cookies associated with this document. If there are none, the value is an empty string. Otherwise, the value is a string: a semicolon-delimited list of "name, value" pairs for all the cookies associated with the page. For example, 
    <code>name=value;expires=date</code>. 
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLDocument
extends Document
{
	/** Assigns the value of the <code><a href=#att-title>title</a></code> property.
	 */
	void setTitle (String title);

	/**
	 * Returns the value of the <code><a href=#att-title>title</a></code> property.
	*/
	String getTitle ();


	/**
	 * Returns the value of the <code><a href=#att-referrer>referrer</a></code> property.
	*/
	String getReferrer ();


	/**
	 * Returns the value of the <code><a href=#att-domain>domain</a></code> property.
	*/
	String getDomain ();


	/**
	 * Returns the value of the <code><a href=#att-URL>URL</a></code> property.
	*/
	String getURL ();


	/** Assigns the value of the <code><a href=#att-body>body</a></code> property.
	 */
	void setBody (HTMLElement body);

	/**
	 * Returns the value of the <code><a href=#att-body>body</a></code> property.
	*/
	HTMLElement getBody ();


	/**
	 * Returns the value of the <code><a href=#att-images>images</a></code> property.
	*/
	HTMLCollection getImages ();


	/**
	 * Returns the value of the <code><a href=#att-applets>applets</a></code> property.
	*/
	HTMLCollection getApplets ();


	/**
	 * Returns the value of the <code><a href=#att-links>links</a></code> property.
	*/
	HTMLCollection getLinks ();


	/**
	 * Returns the value of the <code><a href=#att-forms>forms</a></code> property.
	*/
	HTMLCollection getForms ();


	/**
	 * Returns the value of the <code><a href=#att-anchors>anchors</a></code> property.
	*/
	HTMLCollection getAnchors ();


	/** Assigns the value of the <code><a href=#att-cookie>cookie</a></code> property.
	 */
	void setCookie (String cookie);

	/**
	 * Returns the value of the <code><a href=#att-cookie>cookie</a></code> property.
	*/
	String getCookie ();


/**

  <P>
    <emph>Note.</emph>
This method and the ones following allow a user to add to or replace the structure model of a document using strings of unparsed HTML. At the time of writing alternate methods for providing similar functionality for both HTML and XML documents were being considered. The following methods may be deprecated at some point in the future in favor of a more general-purpose mechanism.
  
</P>
  <P>Open a document stream for writing. If a document exists in the target, this method clears it.
</P>

*/
void open ();

/**

  <P>Closes a document stream opened by 
    <code>open()</code>
and forces rendering.
  
</P>

*/
void close ();

/**

  <P>Write a string of text to a document stream opened by 
    <code>open()</code>. The text is parsed into the document's structure model.
  
</P>

@param text
The string to be parsed into some structure in the document structure model.
*/
void write (String text);

/**

  <P>Write a string of text followed by a newline character to a document stream opened by 
    <code>open()</code>. The text is parsed into the document's structure model.
  
</P>

@param text
The string to be parsed into some structure in the document structure model.
*/
void writeln (String text);

/**

  <P>Returns the Element whose 
    <code>id</code> is given by elementId. If no such element exists, returns 
    <code>null</code>. Behavior is not defined if more than one element has this 
    <code>id</code>. 
  
</P>

@return The matching element.
@param elementId
The unique 
  <code>id</code> value for an element.

*/
Element getElementById (String elementId);

/**

  <P>Returns the (possibly empty) collection of elements whose 
    <code>name</code> value is given by 
    <code>elementName</code>.
  
</P>

@return The matching elements.
@param elementName
The 
  <code>name</code> attribute value for an element.

*/
NodeList getElementsByName (String elementName);

}
