/*
 * @(#)ProcessChildren.java	1.4 99/01/27
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.xsl;

import org.w3c.dom.*;

import com.sun.xml.tree.*;


/**
 * Instance of this class represent XSL process-children directives.
 */
class ProcessChildren extends XslNode
{
    public ProcessChildren () { }

    /**
     * This is like template processing, with two differences.
     * First, template processing gets the "source" of the data from
     * the stylesheet, not the input data.  Second, templates have
     * access to some special instructions like macros (as well as
     * "process-children" to kick back to this behavior).
     */
    // package private
    void process (ElementNode current, Node output, XslContext context)
    {
    	Document	outFactory = output.getOwnerDocument ();
    	
	if (outFactory == null)
	    outFactory = (Document) output;

    	// for each child, pattern match OR output
    	for (int i = 0; ; i++) {
    	    Node	node = current.item (i);
    	    Node	out;
    	    
    	    if (node == null)
    	        break;
    	    switch (node.getNodeType ()) {
    	      case TEXT_NODE:
    	        // if !ignorable
    // XXX why?
    	        if (node.getNodeValue ().length () == 0)
    	            continue;
    	        out = outFactory.createTextNode (node.getNodeValue ());
    	        output.appendChild (out);
    	        continue;
    	        
    	      case CDATA_SECTION_NODE:
    	        out = outFactory.createCDATASection (node.getNodeValue ());
    	        output.appendChild (out);
    	        continue;
    	        
    	      case ELEMENT_NODE:
    	        {
    	            Template t = ((StyleSheet)getOwnerDocument ())
    	            		.findTemplate ((ElementNode)node);
    	            t.process ((ElementNode)node, output, context);
    	        }
    	        continue;
    	      
    	      // PIs, comments, DTD, entity refs ... dropped!
    	      // worth revisiting all of those
    	    }
    	}
    }
    
}

