/*
 * $Id: XmlWritable.java,v 1.2 1999/04/04 18:49:15 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.tree;

import java.io.IOException;


/**
 * Objects that can write themselves as XML text do so using this
 * interface.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
public interface XmlWritable
{
    /**
     * This is the primary method used to write an object and
     * its children as XML text.  Implementations with children
     * should use writeChildrenXml to write those children, to
     * allow selective overriding.
     */
    public void writeXml (XmlWriteContext context)
    throws IOException;

    /**
     * Used to write any children of a node.
     */
    public void writeChildrenXml (XmlWriteContext context)
    throws IOException;
}
