// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>Objects implementing the <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> interface are
      used to represent collections of nodes that can be accessed by name. Note
      that <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> does not inherit from
      <A HREF='NodeList.html'><CODE>NodeList</CODE></A>; <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A>s are not maintained in
      any particular order. Objects contained in an object implementing
      <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> may also be accessed by an ordinal index, but
      this is simply to allow convenient enumeration of the contents of a
      <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A>, and does not imply that the DOM specifies an
      order to these Nodes. 

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD><P>The number of nodes in the map. The range of valid child node
	indices is 0 to <code>length-1</code> inclusive. 
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface NamedNodeMap
{
/**
<P>Retrieves a node specified by name.

@return A <A HREF='Node.html'><CODE>Node</CODE></A> (of any type) with the specified
	  name, or <code>null</code> if the specified name did not
	  identify any node in the map. 
@param name
Name of a node to retrieve.
*/
Node getNamedItem (String name);

/**
<P>Adds a node using its <code>nodeName</code> attribute. 
<P>As the <code>nodeName</code> attribute is used to
	derive the name which the node must be stored under, multiple
	nodes of certain types (those that have a "special" string
	value) cannot be stored as the names would clash. This is seen
	as preferable to allowing nodes to be aliased.

@return If the new <A HREF='Node.html'><CODE>Node</CODE></A> replaces an existing node with the
	  same name  the previously existing <A HREF='Node.html'><CODE>Node</CODE></A> is returned,
	  otherwise <code>null</code> is returned.
@param arg
A node to store in a named node map. The node will
	later be accessible using the value of the
	<code>nodeName</code> attribute of the node. If a node with that
	name is already present in the map, it is replaced
	by the new one.
@exception WRONG_DOCUMENT_ERR: Raised if <code>arg</code> was created from a different
	document than the one that created the <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A>.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this
	<A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> is readonly.
<P>INUSE_ATTRIBUTE_ERR: Raised if <code>arg</code> is an <A HREF='Attr.html'><CODE>Attr</CODE></A>
	that is already an attribute of another <A HREF='Element.html'><CODE>Element</CODE></A> object. The
	DOM user must explicitly clone <A HREF='Attr.html'><CODE>Attr</CODE></A>
	nodes to re-use them in other elements.

*/
Node setNamedItem (Node arg) throws DOMException;

/**
<P>Removes a node specified by name. If the removed
    node is an <A HREF='Attr.html'><CODE>Attr</CODE></A> with a default value it is immediately
    replaced.

@return The node removed from the map or <code>null</code>
	    if no node with such a name exists.
@param name
The name of a node to remove.
@exception NOT_FOUND_ERR: Raised if there is no node named
	<code>name</code> in the map.
*/
Node removeNamedItem (String name) throws DOMException;

/**
<P>Returns the <code>index</code>th item in the map.
	If <code>index</code> is greater than or equal to the number
	of nodes in the map, this returns <code>null</code>.

@return The node at the <code>index</code>th position in the
	  <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A>, or <code>null</code> if that is not a
	  valid index.
@param index
Index into the map.
*/
Node item (int index);

	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


}
