/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.tag.rt.sql;

import org.apache.taglibs.standard.tag.common.sql.SetDataSourceTagSupport;

/**
 * <p>Tag handler for &lt;Driver&gt; in JSTL, used to create
 * a simple DataSource for prototyping.</p>
 * 
 */
public class SetDataSourceTag extends SetDataSourceTagSupport {

    //*********************************************************************
    // Accessor methods

    public void setDataSource(Object dataSource) {
	this.dataSource = dataSource;
	this.dataSourceSpecified = true;
    }

    public void setDriver(String driverClassName) {
	this.driverClassName = driverClassName;
    }

    public void setUrl(String jdbcURL) {
	this.jdbcURL = jdbcURL;
    }

    public void setUser(String userName) {
	this.userName = userName;
    }

    public void setPassword(String password) {
	this.password = password;
    }

}
