/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.util;

import com.thebuzzmedia.imgscalr.Scalr;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.activiti.explorer.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)ImageUtil.class.getName());

    public static InputStream resizeImage(InputStream imageInputStream, String mimeType, int maxWidth, int maxHeight) {
        try {
            BufferedImage image = ImageIO.read(imageInputStream);
            int width = Math.min(image.getWidth(), maxWidth);
            int height = Math.min(image.getHeight(), maxHeight);
            Scalr.Mode mode = Scalr.Mode.AUTOMATIC;
            if (image.getHeight() > maxHeight) {
                mode = Scalr.Mode.FIT_TO_HEIGHT;
            }
            if (width != image.getWidth() || height != image.getHeight()) {
                image = Scalr.resize((BufferedImage)image, (Scalr.Mode)mode, (int)width, (int)height);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, Constants.MIMETYPE_EXTENSION_MAPPING.get(mimeType), bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        catch (IOException e) {
            LOGGER.error("Exception while resizing image", (Throwable)e);
            return null;
        }
    }
}

