/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task.listener;

import com.vaadin.ui.Button;
import java.util.Arrays;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.SelectUsersPopupWindow;
import org.activiti.explorer.ui.event.SubmitEvent;
import org.activiti.explorer.ui.event.SubmitEventListener;
import org.activiti.explorer.ui.task.TaskDetailPanel;

public class ReassignAssigneeListener
implements Button.ClickListener {
    private static final long serialVersionUID = 1L;
    protected Task task;
    protected TaskDetailPanel taskDetailPanel;
    protected I18nManager i18nManager;

    public ReassignAssigneeListener(Task task, TaskDetailPanel taskDetailPanel) {
        this.task = task;
        this.taskDetailPanel = taskDetailPanel;
        this.i18nManager = ExplorerApp.get().getI18nManager();
    }

    public void buttonClick(Button.ClickEvent event) {
        List<String> ignoredIds = null;
        if (this.task.getAssignee() != null) {
            ignoredIds = Arrays.asList(this.task.getAssignee());
        }
        final SelectUsersPopupWindow involvePeoplePopupWindow = new SelectUsersPopupWindow(this.i18nManager.getMessage("task.assignee.reassign"), false, ignoredIds);
        involvePeoplePopupWindow.addListener(new SubmitEventListener(){

            @Override
            protected void submitted(SubmitEvent event) {
                String selectedUser = involvePeoplePopupWindow.getSelectedUserId();
                ReassignAssigneeListener.this.task.setAssignee(selectedUser);
                ProcessEngines.getDefaultProcessEngine().getTaskService().setAssignee(ReassignAssigneeListener.this.task.getId(), selectedUser);
                ReassignAssigneeListener.this.taskDetailPanel.notifyAssigneeChanged();
            }

            @Override
            protected void cancelled(SubmitEvent event) {
            }
        });
        ExplorerApp.get().getViewManager().showPopupWindow(involvePeoplePopupWindow);
    }
}

