/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.job;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.runtime.Job;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;
import org.activiti.explorer.ui.management.job.JobPage;

public class JobDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected transient ManagementService managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected NotificationManager notificationManager = ExplorerApp.get().getNotificationManager();
    protected Job job;
    protected JobPage jobPage;

    public JobDetailPanel(String jobId, JobPage jobPage) {
        this.job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        this.jobPage = jobPage;
        this.init();
    }

    protected void init() {
        this.addHeader();
        this.addJobState();
        this.addActions();
    }

    protected void addActions() {
        Button deleteButton = new Button(this.i18nManager.getMessage("job.delete"));
        deleteButton.setIcon(Images.DELETE);
        deleteButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                JobDetailPanel.this.managementService.deleteJob(JobDetailPanel.this.job.getId());
                JobDetailPanel.this.notificationManager.showInformationNotification("job.deleted");
                JobDetailPanel.this.jobPage.refreshSelectNext();
            }
        });
        Button executeButton = new Button(this.i18nManager.getMessage("job.execute"));
        executeButton.setIcon(Images.EXECUTE);
        executeButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    JobDetailPanel.this.managementService.executeJob(JobDetailPanel.this.job.getId());
                    JobDetailPanel.this.jobPage.refreshSelectNext();
                }
                catch (ActivitiException ae) {
                    String errorMessage = ae.getMessage() + (ae.getCause() != null ? " (" + ae.getCause().getClass().getName() + ")" : "");
                    JobDetailPanel.this.notificationManager.showErrorNotification("job.error", errorMessage);
                    JobDetailPanel.this.jobPage.refreshCurrentJobDetails();
                }
            }
        });
        this.jobPage.getToolBar().removeAllButtons();
        this.jobPage.getToolBar().addButton(executeButton);
        this.jobPage.getToolBar().addButton(deleteButton);
    }

    protected void addHeader() {
        GridLayout jobDetails = new GridLayout(3, 2);
        jobDetails.setWidth(100.0f, 8);
        jobDetails.addStyleName("title-block");
        jobDetails.setSpacing(true);
        jobDetails.setMargin(false, false, true, false);
        Embedded image = new Embedded(null, Images.JOB_50);
        jobDetails.addComponent((Component)image, 0, 0, 0, 1);
        Label nameLabel = new Label(this.getJobLabel(this.job));
        nameLabel.addStyleName("h2");
        jobDetails.addComponent((Component)nameLabel, 1, 0, 2, 0);
        PrettyTimeLabel dueDateLabel = new PrettyTimeLabel(this.i18nManager.getMessage("job.duedate"), this.job.getDuedate(), this.i18nManager.getMessage("job.no.dudedate"), false);
        dueDateLabel.addStyleName("job-duedate");
        jobDetails.addComponent((Component)dueDateLabel, 1, 1);
        jobDetails.setColumnExpandRatio(1, 1.0f);
        jobDetails.setColumnExpandRatio(2, 1.0f);
        this.addDetailComponent((Component)jobDetails);
    }

    protected String getJobLabel(Job theJob) {
        if (theJob instanceof TimerEntity) {
            return this.i18nManager.getMessage("job.timer", theJob.getId());
        }
        if (theJob instanceof MessageEntity) {
            return this.i18nManager.getMessage("job.message", theJob.getId());
        }
        return this.i18nManager.getMessage("job.default.name", theJob.getId());
    }

    protected void addJobState() {
        Label processDefinitionHeader = new Label(this.i18nManager.getMessage("job.header.execution"));
        processDefinitionHeader.addStyleName("h3");
        processDefinitionHeader.addStyleName("block-holder");
        processDefinitionHeader.setWidth(100.0f, 8);
        this.addComponent((Component)processDefinitionHeader);
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setSizeFull();
        layout.setMargin(true, false, true, false);
        this.addDetailComponent((Component)layout);
        this.setDetailExpandRatio((Component)layout, 1.0f);
        if (this.job.getExceptionMessage() != null) {
            Label retrieslabel = new Label(this.getRetriesLabel(this.job));
            layout.addComponent((Component)retrieslabel);
            Label exceptionMessageLabel = new Label(this.i18nManager.getMessage("job.error") + ": " + this.job.getExceptionMessage());
            exceptionMessageLabel.addStyleName("job-exception-message");
            layout.addComponent((Component)exceptionMessageLabel);
            String stack = this.managementService.getJobExceptionStacktrace(this.job.getId());
            Label stackTraceLabel = new Label(stack);
            stackTraceLabel.setContentMode(1);
            stackTraceLabel.addStyleName("job-exception-trace");
            stackTraceLabel.setSizeFull();
            Panel stackPanel = new Panel();
            stackPanel.setWidth(100.0f, 8);
            stackPanel.setSizeFull();
            stackPanel.setScrollable(true);
            stackPanel.addComponent((Component)stackTraceLabel);
            layout.addComponent((Component)stackPanel);
            layout.setExpandRatio((Component)stackPanel, 1.0f);
        } else if (this.job.getProcessDefinitionId() != null) {
            JobEntity jobEntity = (JobEntity)this.job;
            if (jobEntity.getJobHandlerType().equals("suspend-processdefinition")) {
                this.addLinkToProcessDefinition(layout, this.i18nManager.getMessage("job.suspend.processdefinition"), false);
            } else if (jobEntity.getJobHandlerType().equals("activate-processdefinition")) {
                this.addLinkToProcessDefinition(layout, this.i18nManager.getMessage("job.activate.processdefinition"), true);
            } else {
                this.addNotYetExecutedLabel(layout);
            }
        } else {
            this.addNotYetExecutedLabel(layout);
        }
    }

    protected void addLinkToProcessDefinition(VerticalLayout verticalLayout, String labelText, final boolean isSuspendedProcessDefinition) {
        HorizontalLayout layout = new HorizontalLayout();
        verticalLayout.addComponent((Component)layout);
        Label processDefinitionLabel = new Label(labelText);
        processDefinitionLabel.setSizeUndefined();
        layout.addComponent((Component)processDefinitionLabel);
        layout.addComponent((Component)new Label("&nbsp;", 3));
        Button showProcessDefinitionLink = new Button(this.job.getProcessDefinitionId());
        showProcessDefinitionLink.addStyleName("link");
        showProcessDefinitionLink.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (isSuspendedProcessDefinition) {
                    ExplorerApp.get().getViewManager().showSuspendedProcessDefinitionsPage(JobDetailPanel.this.job.getProcessDefinitionId());
                } else {
                    ExplorerApp.get().getViewManager().showActiveProcessDefinitionsPage(JobDetailPanel.this.job.getProcessDefinitionId());
                }
            }
        });
        layout.addComponent((Component)showProcessDefinitionLink);
    }

    private void addNotYetExecutedLabel(VerticalLayout layout) {
        Label noException = new Label(this.i18nManager.getMessage("job.not.executed"));
        layout.addComponent((Component)noException);
        layout.setExpandRatio((Component)noException, 1.0f);
    }

    protected String getRetriesLabel(Job theJob) {
        String retriesString = theJob.getRetries() <= 0 ? this.i18nManager.getMessage("job.no.retries") : this.i18nManager.getMessage("job.retries", theJob.getRetries());
        return retriesString;
    }
}

