/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management;

import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.custom.ToolbarEntry;
import org.activiti.explorer.ui.custom.ToolbarPopupEntry;
import org.activiti.explorer.ui.management.deployment.NewDeploymentListener;

public class ManagementMenuBar
extends ToolBar {
    private static final long serialVersionUID = 1L;
    public static final String ENTRY_DATABASE = "database";
    public static final String ENTRY_DEPLOYMENTS = "deployments";
    public static final String ENTRY_ACTIVE_PROCESS_DEFINITIONS = "activeProcessDefinitions";
    public static final String ENTRY_SUSPENDED_PROCESS_DEFINITIONS = "suspendedProcessDefinitions";
    public static final String ENTRY_JOBS = "jobs";
    public static final String ENTRY_USERS = "users";
    public static final String ENTRY_GROUPS = "groups";
    public static final String ENTRY_ADMIN = "administration";
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();

    public ManagementMenuBar() {
        this.setWidth("100%");
        this.initToolbarEntries();
    }

    protected void initToolbarEntries() {
        this.addDatabaseToolbarEntry();
        this.addDeploymentsToolbarEntry();
        this.addActiveProcessDefinitionsEntry();
        this.addSuspendedProcessDefinitionsEntry();
        this.addJobsToolbarEntry();
        this.addUsersToolbarEntry();
        this.addGroupToolbarEntry();
        this.addAdministrationToolbarEntry();
    }

    protected void addDatabaseToolbarEntry() {
        this.addToolbarEntry(ENTRY_DATABASE, this.i18nManager.getMessage("management.menu.database"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showDatabasePage();
            }
        });
    }

    protected void addDeploymentsToolbarEntry() {
        ToolbarPopupEntry deploymentEntry = this.addPopupEntry(ENTRY_DEPLOYMENTS, this.i18nManager.getMessage("management.menu.deployments"));
        deploymentEntry.addMenuItem(this.i18nManager.getMessage("management.menu.deployments.show.all"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showDeploymentPage();
            }
        });
        deploymentEntry.addMenuItem(this.i18nManager.getMessage("management.menu.deployments.upload"), new NewDeploymentListener());
    }

    protected void addActiveProcessDefinitionsEntry() {
        this.addToolbarEntry(ENTRY_ACTIVE_PROCESS_DEFINITIONS, this.i18nManager.getMessage("management.menu.active.processdefinitions"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showActiveProcessDefinitionsPage();
            }
        });
    }

    protected void addSuspendedProcessDefinitionsEntry() {
        this.addToolbarEntry(ENTRY_SUSPENDED_PROCESS_DEFINITIONS, this.i18nManager.getMessage("management.menu.suspended.processdefinitions"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showSuspendedProcessDefinitionsPage();
            }
        });
    }

    protected void addJobsToolbarEntry() {
        this.addToolbarEntry(ENTRY_JOBS, this.i18nManager.getMessage("management.menu.jobs"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showJobPage();
            }
        });
    }

    protected void addUsersToolbarEntry() {
        this.addToolbarEntry(ENTRY_USERS, this.i18nManager.getMessage("management.menu.users"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showUserPage();
            }
        });
    }

    protected void addGroupToolbarEntry() {
        this.addToolbarEntry(ENTRY_GROUPS, this.i18nManager.getMessage("management.menu.groups"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showGroupPage();
            }
        });
    }

    protected void addAdministrationToolbarEntry() {
        this.addToolbarEntry(ENTRY_ADMIN, this.i18nManager.getMessage("management.menu.admin"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ManagementMenuBar.this.viewManager.showAdministrationPage();
            }
        });
    }
}

