/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.ui.Label;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.util.time.HumanTime;

public class PrettyTimeLabel
extends Label {
    private static final long serialVersionUID = 1L;
    protected String labelTemplate;
    protected Date date;
    protected String noDateCaption;
    protected boolean showTime;

    public PrettyTimeLabel(Date date, boolean showTime) {
        this(date, "", showTime);
    }

    public PrettyTimeLabel(Date date, String noDateCaption, boolean showTime) {
        this(null, date, noDateCaption, showTime);
    }

    public PrettyTimeLabel(String labelTemplate, Date date, String noDateCaption, boolean showTime) {
        this.labelTemplate = labelTemplate;
        this.date = date;
        this.noDateCaption = noDateCaption;
        this.showTime = showTime;
        this.init();
    }

    protected void init() {
        I18nManager i18nManager = ExplorerApp.get().getI18nManager();
        if (this.date != null) {
            SimpleDateFormat dateFormat = null;
            dateFormat = this.showTime ? new SimpleDateFormat("dd-MM-yyyy hh:mm:ss") : new SimpleDateFormat("dd-MM-yyyy");
            if (this.labelTemplate != null) {
                super.setValue((Object)MessageFormat.format(this.labelTemplate, new HumanTime(i18nManager).format(this.date)));
            } else {
                super.setValue((Object)new HumanTime(i18nManager).format(this.date));
            }
            this.setDescription(dateFormat.format(this.date));
        } else {
            super.setValue((Object)this.noDateCaption);
            this.setDescription(this.noDateCaption);
        }
    }

    public void setValue(Object newValue) {
        if (newValue instanceof Date) {
            this.date = (Date)newValue;
            this.init();
        } else if (newValue instanceof String) {
            this.date = null;
            this.init();
        } else {
            throw new IllegalArgumentException("Can only set " + Date.class + " as new value for prettyTimeLabel");
        }
    }
}

