/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.navigation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.navigation.ActiveProcessDefinitionNavigator;
import org.activiti.explorer.navigation.DatabaseNavigator;
import org.activiti.explorer.navigation.DeploymentNavigator;
import org.activiti.explorer.navigation.GroupNavigator;
import org.activiti.explorer.navigation.JobNavigator;
import org.activiti.explorer.navigation.MyProcessesNavigator;
import org.activiti.explorer.navigation.Navigator;
import org.activiti.explorer.navigation.ProcessModelNavigator;
import org.activiti.explorer.navigation.ProcessNavigator;
import org.activiti.explorer.navigation.ReportNavigator;
import org.activiti.explorer.navigation.SavedReportNavigator;
import org.activiti.explorer.navigation.SuspendedProcessDefinitionNavigator;
import org.activiti.explorer.navigation.TaskNavigator;
import org.activiti.explorer.navigation.UserNavigator;
import org.activiti.explorer.ui.management.admin.AdministrationNavigator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class NavigatorManager
implements InitializingBean,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Navigator> navigationHandlers = new HashMap<String, Navigator>();
    protected Navigator defaultHandler;

    public void addNavigator(Navigator handler) {
        this.navigationHandlers.put(handler.getTrigger(), handler);
    }

    public Navigator getNavigator(String trigger) {
        if (trigger != null) {
            return this.navigationHandlers.get(trigger);
        }
        return null;
    }

    public Navigator getDefaultNavigator() {
        if (this.defaultHandler == null) {
            throw new IllegalStateException("No default navigation handler has been set");
        }
        return this.defaultHandler;
    }

    public void setDefaultNavigator(Navigator handler) {
        this.defaultHandler = handler;
    }

    public void afterPropertiesSet() throws Exception {
        this.addNavigator(new TaskNavigator());
        this.addNavigator(new ProcessNavigator());
        this.addNavigator(new ProcessModelNavigator());
        this.addNavigator(new DeploymentNavigator());
        this.addNavigator(new DatabaseNavigator());
        this.addNavigator(new JobNavigator());
        this.addNavigator(new UserNavigator());
        this.addNavigator(new GroupNavigator());
        this.addNavigator(new AdministrationNavigator());
        this.addNavigator(new MyProcessesNavigator());
        this.addNavigator(new SavedReportNavigator());
        this.addNavigator(new ReportNavigator());
        this.addNavigator(new ActiveProcessDefinitionNavigator());
        this.addNavigator(new SuspendedProcessDefinitionNavigator());
    }
}

