/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private ObjectMapper objectMapper;

    protected <T> JacksonRepresentation<T> create(MediaType mediaType, T source) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getObjectMapper());
        return result;
    }

    protected <T> JacksonRepresentation<T> create(Representation source, Class<T> objectClass) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getObjectMapper());
        return result;
    }

    protected ObjectMapper createObjectMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper(jsonFactory);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, JacksonRepresentation.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.objectMapper == null) {
                    this.objectMapper = this.createObjectMapper();
                }
            }
        }
        return this.objectMapper;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        result = source instanceof JacksonRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : 0.5f));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof JacksonRepresentation) {
            result = 1.0f;
        } else if (target != null && JacksonRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            result = 0.8f;
        }
        return result;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        JacksonRepresentation<T> result = null;
        JacksonRepresentation<T> jacksonSource = null;
        if (source instanceof JacksonRepresentation) {
            jacksonSource = (JacksonRepresentation<T>)source;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            jacksonSource = this.create(source, target);
        }
        if (jacksonSource != null) {
            result = target != null && JacksonRepresentation.class.isAssignableFrom(target) ? jacksonSource : (JacksonRepresentation<T>)((Object)jacksonSource.getObject());
        }
        return (T)((Object)result);
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        JacksonRepresentation<Object> result = null;
        if (source instanceof JacksonRepresentation) {
            result = (JacksonRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                JacksonRepresentation<Object> jacksonRepresentation;
                result = jacksonRepresentation = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
    }
}

