/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.ui.Label;
import java.io.Serializable;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.engine.task.Event;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;

public class TaskEventTextResolver
implements Serializable {
    private static final long serialVersionUID = -1241011503689621172L;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();

    public Label resolveText(Event event) {
        IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        User user = (User)identityService.createUserQuery().userId(event.getUserId()).singleResult();
        String eventAuthor = "<span class='task-event-author'>" + user.getFirstName() + " " + user.getLastName() + "</span> ";
        String text = null;
        if ("AddUserLink".equals(event.getAction())) {
            User involvedUser = (User)identityService.createUserQuery().userId((String)event.getMessageParts().get(0)).singleResult();
            text = this.i18nManager.getMessage("event.add.user.link", eventAuthor, involvedUser.getFirstName() + " " + involvedUser.getLastName(), event.getMessageParts().get(1));
        } else if ("DeleteUserLink".equals(event.getAction())) {
            User involvedUser = (User)identityService.createUserQuery().userId((String)event.getMessageParts().get(0)).singleResult();
            text = this.i18nManager.getMessage("event.delete.user.link", eventAuthor, involvedUser.getFirstName() + " " + involvedUser.getLastName(), event.getMessageParts().get(1));
        } else {
            text = "AddGroupLink".equals(event.getAction()) ? this.i18nManager.getMessage("event.add.group.link", eventAuthor, event.getMessageParts().get(0), event.getMessageParts().get(1)) : ("DeleteGroupLink".equals(event.getAction()) ? this.i18nManager.getMessage("event.delete.group.link", eventAuthor, event.getMessageParts().get(0), event.getMessageParts().get(1)) : ("AddAttachment".equals(event.getAction()) ? this.i18nManager.getMessage("event.add.attachment", eventAuthor, event.getMessage()) : ("DeleteAttachment".equals(event.getAction()) ? this.i18nManager.getMessage("event.delete.attachment", eventAuthor, event.getMessage()) : ("AddComment".equals(event.getAction()) ? this.i18nManager.getMessage("event.comment", eventAuthor, event.getMessage()) : text + this.i18nManager.getMessage("event.default", eventAuthor, event.getMessage())))));
        }
        return new Label(text, 3);
    }
}

