/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.data.Property;
import com.vaadin.event.LayoutEvents;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.task.PriorityComboBox;
import org.activiti.explorer.ui.task.PriorityLabel;

public class PriorityComponent
extends CssLayout {
    private static final long serialVersionUID = 1L;
    protected Task task;
    protected I18nManager i18nManager;
    protected transient TaskService taskService;
    protected PriorityLabel priorityLabel;
    protected PriorityComboBox priorityComboBox;

    public PriorityComponent(Task task, I18nManager i18nManager, TaskService taskService) {
        this.task = task;
        this.i18nManager = i18nManager;
        this.taskService = taskService;
        this.setSizeUndefined();
        this.initPriorityLabel();
        this.initPriorityComboBox();
        this.initLayoutClickListener();
        this.initComboBoxListener();
    }

    protected void initPriorityLabel() {
        this.priorityLabel = new PriorityLabel(this.task, this.i18nManager);
        this.addComponent((Component)this.priorityLabel);
    }

    protected void initPriorityComboBox() {
        this.priorityComboBox = new PriorityComboBox(this.i18nManager, this.priorityLabel.getValue());
    }

    protected void initLayoutClickListener() {
        this.addListener(new LayoutEvents.LayoutClickListener(){

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                if (event.getClickedComponent() != null && event.getClickedComponent().equals((Object)PriorityComponent.this.priorityLabel)) {
                    PriorityComponent.this.replaceComponent((Component)PriorityComponent.this.priorityLabel, (Component)PriorityComponent.this.priorityComboBox);
                }
            }
        });
    }

    protected void initComboBoxListener() {
        this.priorityComboBox.addListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                PriorityComponent.this.task.setPriority(PriorityComponent.this.priorityComboBox.getPriority());
                PriorityComponent.this.taskService.saveTask(PriorityComponent.this.task);
                PriorityComponent.this.priorityLabel.setValue(PriorityComponent.this.task.getPriority());
                PriorityComponent.this.replaceComponent((Component)PriorityComponent.this.priorityComboBox, (Component)PriorityComponent.this.priorityLabel);
            }
        });
    }
}

