/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.job;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.job.JobDetailPanel;
import org.activiti.explorer.ui.management.job.JobListQuery;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class JobPage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected String jobId;
    protected Table jobTable;
    protected LazyLoadingContainer jobListContainer;

    public JobPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("job"));
    }

    public JobPage(String jobId) {
        this();
        this.jobId = jobId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.jobId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.jobListContainer.getIndexForObjectId(this.jobId));
        }
    }

    @Override
    protected Table createList() {
        final Table jobTable = new Table();
        JobListQuery jobListQuery = new JobListQuery();
        this.jobListContainer = new LazyLoadingContainer(jobListQuery, 30);
        jobTable.setContainerDataSource((Container)this.jobListContainer);
        jobTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 8811553575319455854L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = jobTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    String jobId = (String)item.getItemProperty((Object)"id").getValue();
                    JobPage.this.setDetailComponent((Component)new JobDetailPanel(jobId, JobPage.this));
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("job", jobId));
                } else {
                    JobPage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("job"));
                }
            }
        });
        jobTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.JOB_22));
        jobTable.setColumnWidth((Object)"icon", 22);
        jobTable.addContainerProperty((Object)"name", String.class, null);
        jobTable.setColumnHeaderMode(-1);
        return jobTable;
    }

    public void refreshCurrentJobDetails() {
        if (this.table.getValue() != null) {
            Item selectedJob = this.table.getItem(this.table.getValue());
            this.setDetailComponent((Component)new JobDetailPanel((String)selectedJob.getItemProperty((Object)"id").getValue(), this));
        }
    }
}

