/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.db;

import com.vaadin.data.Container;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.management.TableMetaData;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.management.db.TableDataQuery;

public class DatabaseDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected transient ManagementService managementService;
    protected I18nManager i18nManager;
    protected String tableName;

    public DatabaseDetailPanel(String tableName) {
        this.tableName = tableName;
        this.managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.addStyleName("white");
        this.setSizeFull();
        this.addTableName();
        this.addTableData();
    }

    protected void addTableName() {
        HorizontalLayout header = new HorizontalLayout();
        header.setWidth(100.0f, 8);
        header.addStyleName("title-block");
        header.setSpacing(true);
        Embedded image = new Embedded(null, Images.DATABASE_50);
        header.addComponent((Component)image);
        header.setComponentAlignment((Component)image, Alignment.MIDDLE_LEFT);
        header.setMargin(false, false, true, false);
        Label name = new Label(this.tableName);
        name.addStyleName("h2");
        header.addComponent((Component)name);
        header.setExpandRatio((Component)name, 1.0f);
        header.setComponentAlignment((Component)name, Alignment.MIDDLE_LEFT);
        this.addDetailComponent((Component)header);
        Label spacer = new Label();
        spacer.setWidth(100.0f, 8);
        spacer.addStyleName("block-holder");
        this.addDetailComponent((Component)spacer);
    }

    protected void addTableData() {
        TableDataQuery lazyLoadingQuery = new TableDataQuery(this.tableName, this.managementService);
        LazyLoadingContainer lazyLoadingContainer = new LazyLoadingContainer(lazyLoadingQuery, 30);
        if (lazyLoadingContainer.size() > 0) {
            Table data = new Table();
            data.setContainerDataSource((Container)lazyLoadingContainer);
            data.setEditable(false);
            data.setSelectable(true);
            data.setColumnReorderingAllowed(true);
            if (lazyLoadingQuery.size() < 10) {
                data.setPageLength(0);
            } else {
                data.setPageLength(10);
            }
            this.addDetailComponent((Component)data);
            data.setWidth(100.0f, 8);
            data.setHeight(100.0f, 8);
            data.addStyleName("database-table");
            this.setDetailExpandRatio((Component)data, 1.0f);
            TableMetaData metaData = this.managementService.getTableMetaData(this.tableName);
            for (String columnName : metaData.getColumnNames()) {
                data.addContainerProperty((Object)columnName, String.class, null);
            }
        } else {
            Label noDataLabel = new Label(this.i18nManager.getMessage("database.no.rows"));
            noDataLabel.addStyleName("light");
            this.addDetailComponent((Component)noDataLabel);
            this.setDetailExpandRatio((Component)noDataLabel, 1.0f);
        }
    }
}

