/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content.email;

import com.vaadin.ui.AbstractLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.util.json.JSONObject;
import org.activiti.engine.impl.util.json.JSONTokener;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;

public class EmailDetailPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected transient TaskService taskService;
    protected Label content;
    protected Attachment attachment;
    protected GridLayout gridLayout;

    public EmailDetailPanel(Attachment attachment) {
        this.setSizeFull();
        ((AbstractLayout)this.getContent()).setMargin(true);
        ((Layout.SpacingHandler)this.getContent()).setSpacing(true);
        this.addStyleName("light");
        this.attachment = attachment;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.gridLayout = new GridLayout(2, 4);
        this.gridLayout.setSpacing(true);
        this.addComponent((Component)this.gridLayout);
        InputStream contentStream = this.taskService.getAttachmentContent(attachment.getId());
        JSONObject emailJson = new JSONObject(new JSONTokener((Reader)new InputStreamReader(contentStream)));
        String html = emailJson.getString("htmlContent");
        String subject = emailJson.getString("subject");
        String recipients = emailJson.getString("recipients");
        String sentDate = emailJson.getString("sentDate");
        String receivedDate = emailJson.getString("receivedDate");
        this.addSimpleRow("email.subject", subject);
        this.addSimpleRow("email.recipients", recipients);
        this.addSimpleRow("email.sent.date", sentDate);
        this.addSimpleRow("email.received.date", receivedDate);
        this.addHtmlContent(html);
    }

    protected void addHtmlContent(String html) {
        Panel panel = new Panel();
        panel.setWidth(800.0f, 0);
        panel.setHeight(300.0f, 0);
        this.content = new Label(html, 3);
        this.content.setHeight(100.0f, 8);
        panel.addComponent((Component)this.content);
        this.addComponent((Component)panel);
    }

    protected void addSimpleRow(String labelMessageKey, String content) {
        this.addLabel(labelMessageKey);
        Label subjectLabel = new Label(content);
        subjectLabel.setSizeUndefined();
        subjectLabel.addStyleName("bold");
        this.gridLayout.addComponent((Component)subjectLabel);
        this.gridLayout.setComponentAlignment((Component)subjectLabel, Alignment.MIDDLE_LEFT);
    }

    protected void addLabel(String messageKey) {
        Label theLabel = new Label(this.i18nManager.getMessage(messageKey));
        theLabel.setSizeUndefined();
        this.gridLayout.addComponent((Component)theLabel);
    }
}

