/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerExecuteNestedActivityJobHandler
implements JobHandler {
    private static Logger log = LoggerFactory.getLogger(TimerExecuteNestedActivityJobHandler.class);
    public static final String TYPE = "timer-transition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl borderEventActivity = execution.getProcessDefinition().findActivity(configuration);
        if (borderEventActivity == null) {
            throw new ActivitiException("Error while firing timer: border event activity " + configuration + " not found");
        }
        try {
            borderEventActivity.getActivityBehavior().execute(execution);
        }
        catch (RuntimeException e) {
            log.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception during timer execution", (Throwable)e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

