/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.TimeoutException;
import org.smslib.modem.CNMIDetector;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.ATHandler;

public abstract class AATHandler {
    private ModemGateway gateway;
    private String storageLocations;
    private String description;
    String[] terminators;
    String[] unsolicitedResponses;

    public AATHandler(ModemGateway myGateway) {
        this.gateway = myGateway;
        this.storageLocations = "";
    }

    public ModemGateway getGateway() {
        return this.gateway;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStorageLocations() {
        return this.storageLocations;
    }

    public void setStorageLocations(String myStorageLocations) {
        this.storageLocations = myStorageLocations;
    }

    public void addStorageLocation(String myStorageLocation) {
        this.storageLocations = this.storageLocations + myStorageLocation;
    }

    public String[] getTerminators() {
        return this.terminators;
    }

    public String[] getUnsolicitedResponses() {
        return this.unsolicitedResponses;
    }

    public String getUnsolicitedResponse(int index) {
        return this.unsolicitedResponses[index];
    }

    public abstract void sync() throws IOException, InterruptedException;

    public abstract void reset() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract void echoOff() throws IOException, InterruptedException;

    public abstract void init() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract void done() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean enterPin(String var1) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract CNMIDetector getIndications();

    public abstract String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getNetworkOperator() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean switchStorageLocation(String var1) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract void switchToCmdMode() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract int sendMessage(int var1, String var2, String var3, String var4) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String listMessages(InboundMessage.MessageClasses var1) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getMessageByIndex(int var1) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract boolean deleteMessage(int var1, String var2) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String send(String var1) throws TimeoutException, GatewayException, IOException, InterruptedException;

    public abstract String getNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract void readStorageLocations() throws Exception;

    public abstract String sendCustomATCommand(String var1) throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract String sendUSSDCommand(String var1) throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract String sendUSSDCommand(String var1, boolean var2) throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract boolean sendUSSDRequest(String var1, String var2, String var3) throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract String formatUSSDResponse(String var1);

    public abstract String readPhonebookLocations() throws GatewayException, TimeoutException, IOException, InterruptedException;

    public abstract String readPhonebook(String var1) throws GatewayException, TimeoutException, IOException;

    public abstract AGateway.AsyncEvents processUnsolicitedEvents(String var1) throws IOException;

    public static AATHandler load(ModemGateway gateway, String gsmManuf, String gsmModel) throws RuntimeException {
        String BASE_HANDLER = ATHandler.class.getName();
        String[] handlerClassNames = new String[]{null, null, BASE_HANDLER};
        String[] handlerDescriptions = new String[]{null, null, "Generic"};
        StringBuffer handlerClassName = new StringBuffer(BASE_HANDLER);
        if (gsmManuf != null && gsmManuf.length() != 0) {
            handlerClassName.append("_").append(gsmManuf);
            handlerClassNames[1] = handlerClassName.toString();
            handlerDescriptions[1] = gsmManuf + " (Generic)";
            if (gsmModel != null && gsmModel.length() != 0) {
                handlerClassName.append("_").append(gsmModel);
                handlerClassNames[0] = handlerClassName.toString();
                handlerDescriptions[0] = gsmManuf + " " + gsmModel;
            }
        }
        AATHandler atHandler = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (handlerClassNames[i] == null) continue;
                Class<?> handlerClass = Class.forName(handlerClassNames[i]);
                Constructor<?> handlerConstructor = handlerClass.getConstructor(ModemGateway.class);
                atHandler = (AATHandler)handlerConstructor.newInstance(gateway);
                atHandler.description = handlerDescriptions[i];
                break;
            }
            catch (Exception ex) {
                if (i != 2) continue;
                ex.printStackTrace();
                throw new RuntimeException("Class AATHandler: Cannot initialize handler!");
            }
        }
        return atHandler;
    }

    public int findMatchingTerminator(String response) {
        for (int i = 0; i < this.terminators.length; ++i) {
            if (!response.matches(this.terminators[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isUnsolicitedResponse(int terminatorIndex) {
        return terminatorIndex >= this.terminators.length - 5;
    }

    public boolean isUnsolicitedResponse(String response) {
        int i = this.findMatchingTerminator(response);
        return this.isUnsolicitedResponse(i);
    }

    public boolean matchesTerminator(String response) {
        return this.findMatchingTerminator(response) >= 0;
    }
}

