/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.InvalidMessageException;
import org.smslib.Service;
import org.smslib.TimeoutException;
import org.smslib.USSDResponse;
import org.smslib.helper.Logger;
import org.smslib.modem.ModemGateway;
import org.smslib.notify.CallNotification;
import org.smslib.notify.InboundMessageNotification;
import org.smslib.threading.AServiceThread;

public abstract class AModemDriver {
    private static final String rxErrorWithCode = "\\s*[\\p{ASCII}]*\\s*\\+(CM[ES])\\s+ERROR: (\\d+)\\s";
    private static final String rxPlainError = "\\s*[\\p{ASCII}]*\\s*(ERROR|NO CARRIER|NO DIALTONE)\\s";
    private Object SYNC_Reader;
    private Object SYNC_Commander;
    private Object SYNC_InboundReader;
    private ModemGateway gateway;
    private boolean dataReceived;
    private volatile boolean connected;
    private CharQueue charQueue;
    private ModemReader modemReader;
    private KeepAlive keepAlive;
    private AsyncNotifier asyncNotifier;
    private AsyncMessageProcessor asyncMessageProcessor;
    private CNMIEmulatorProcessor cnmiEmulationProcessor;
    private int lastError;
    static int OK = 0;

    protected AModemDriver(ModemGateway myGateway, String deviceParms) {
        this.setSYNCReader(new Object());
        this.setSYNCCommander(new Object());
        this.setSYNCInboundReader(new Object());
        this.setGateway(myGateway);
        this.setConnected(false);
        this.setDataReceived(false);
        this.setCharQueue(new CharQueue());
    }

    protected abstract void connectPort() throws GatewayException, IOException, InterruptedException;

    protected abstract void disconnectPort() throws IOException, InterruptedException;

    protected abstract void clear() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getSYNCCommander();
        synchronized (object) {
            try {
                this.connectPort();
                this.setConnected(true);
                this.setKeepAlive(new KeepAlive("KeepAlive [" + this.getGateway().getGatewayId() + "]", Service.getInstance().getSettings().SERIAL_KEEPALIVE_INTERVAL * 1000));
                this.setCnmiEmulationProcessor(new CNMIEmulatorProcessor("CNMIEmulatorProcessor [" + this.getGateway().getGatewayId() + "]", Service.getInstance().getSettings().CNMI_EMULATOR_INTERVAL * 1000));
                this.setModemReader(new ModemReader());
                this.setAsyncNotifier(new AsyncNotifier());
                this.setAsyncMessageProcessor(new AsyncMessageProcessor());
                this.clearBuffer();
                this.getGateway().getATHandler().reset();
                this.getGateway().getATHandler().sync();
                this.getGateway().getATHandler().echoOff();
                if (this.getGateway().getCustomInitString() != null && this.getGateway().getCustomInitString().length() > 0) {
                    this.write(this.getGateway().getCustomInitString() + "\r");
                    this.getGateway().getATHandler().echoOff();
                }
                while (true) {
                    String response = this.getGateway().getATHandler().getSimStatus();
                    while (response.indexOf("BUSY") >= 0) {
                        Logger.getInstance().logDebug("SIM found busy, waiting...", null, this.getGateway().getGatewayId());
                        Thread.sleep(Service.getInstance().getSettings().AT_WAIT_SIMPIN);
                        response = this.getGateway().getATHandler().getSimStatus();
                    }
                    if (response.indexOf("SIM PIN2") >= 0) {
                        Logger.getInstance().logDebug("SIM requesting PIN2.", null, this.getGateway().getGatewayId());
                        if (this.getGateway().getSimPin2() == null || this.getGateway().getSimPin2().length() == 0) {
                            throw new GatewayException("The GSM modem requires SIM PIN2 to operate.");
                        }
                        if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin2())) {
                            throw new GatewayException("SIM PIN2 provided is not accepted by the GSM modem.");
                        }
                        Thread.sleep(Service.getInstance().getSettings().AT_WAIT_SIMPIN);
                        continue;
                    }
                    if (response.indexOf("SIM PIN") >= 0) {
                        Logger.getInstance().logDebug("SIM requesting PIN.", null, this.getGateway().getGatewayId());
                        if (this.getGateway().getSimPin() == null || this.getGateway().getSimPin().length() == 0) {
                            throw new GatewayException("The GSM modem requires SIM PIN to operate.");
                        }
                        if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin())) {
                            throw new GatewayException("SIM PIN provided is not accepted by the GSM modem.");
                        }
                        Thread.sleep(Service.getInstance().getSettings().AT_WAIT_SIMPIN);
                        continue;
                    }
                    if (response.indexOf("READY") >= 0 || response.indexOf("OK") >= 0) break;
                    if (response.indexOf("ERROR") >= 0) {
                        Logger.getInstance().logWarn("Erroneous CPIN response, proceeding with defaults.", null, this.getGateway().getGatewayId());
                        break;
                    }
                    Logger.getInstance().logWarn("Cannot understand SIMPIN response: " + response + ", will wait for a while...", null, this.getGateway().getGatewayId());
                    Thread.sleep(Service.getInstance().getSettings().AT_WAIT_SIMPIN);
                }
                this.getGateway().getATHandler().echoOff();
                this.getGateway().getATHandler().init();
                this.getGateway().getATHandler().echoOff();
                if (!this.waitForNetworkRegistration()) {
                    Logger.getInstance().logWarn("Network Registration failed, proceeding with defaults.", null, this.getGateway().getGatewayId());
                }
                this.getGateway().getATHandler().setVerboseErrors();
                if (this.getGateway().getATHandler().getStorageLocations().length() == 0) {
                    try {
                        this.getGateway().getATHandler().readStorageLocations();
                        Logger.getInstance().logInfo("MEM: Storage Locations Found: " + this.getGateway().getATHandler().getStorageLocations(), null, this.getGateway().getGatewayId());
                    }
                    catch (Exception e) {
                        this.getGateway().getATHandler().setStorageLocations("--");
                        Logger.getInstance().logWarn("Storage locations could *not* be retrieved, will proceed with defaults.", e, this.getGateway().getGatewayId());
                    }
                }
                if (!this.getGateway().getATHandler().setIndications()) {
                    Logger.getInstance().logWarn("Callback indications were *not* set succesfully!", null, this.getGateway().getGatewayId());
                    this.getCnmiEmulationProcessor().enable();
                } else if (this.getGateway().getATHandler().getIndications().getMode().equals("0")) {
                    this.getCnmiEmulationProcessor().enable();
                }
                if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
                    if (!this.getGateway().getATHandler().setPduProtocol()) {
                        throw new GatewayException("The GSM modem does not support the PDU protocol.");
                    }
                } else if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT && !this.getGateway().getATHandler().setTextProtocol()) {
                    throw new GatewayException("The GSM modem does not support the TEXT protocol.");
                }
            }
            catch (TimeoutException t) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw t;
            }
            catch (GatewayException t) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw t;
            }
            catch (IOException t) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw t;
            }
            catch (InterruptedException t) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw t;
            }
        }
    }

    protected void disconnect() throws IOException, InterruptedException {
        this.setConnected(false);
        if (this.getKeepAlive() != null) {
            this.getKeepAlive().cancel();
            this.setKeepAlive(null);
        }
        if (this.getCnmiEmulationProcessor() != null) {
            this.getCnmiEmulationProcessor().cancel();
            this.setCnmiEmulationProcessor(null);
        }
        if (this.getAsyncNotifier() != null) {
            this.getAsyncNotifier().interrupt();
            this.getAsyncNotifier().join();
            this.setAsyncNotifier(null);
        }
        if (this.getAsyncMessageProcessor() != null) {
            this.getAsyncMessageProcessor().interrupt();
            this.getAsyncMessageProcessor().join();
            this.setAsyncMessageProcessor(null);
        }
        if (this.getModemReader() != null) {
            this.getModemReader().interrupt();
            this.getModemReader().join();
            this.setModemReader(null);
        }
        this.disconnectPort();
    }

    public abstract void write(char var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    protected abstract int read() throws IOException;

    protected abstract boolean portHasData() throws IOException;

    public boolean dataAvailable() throws InterruptedException {
        return this.getCharQueue().peek() != -1;
    }

    public void write(String s) throws IOException {
        Logger.getInstance().logDebug("SEND :" + this.formatLog(s), null, this.getGateway().getGatewayId());
        this.write(s.getBytes());
    }

    public void addToQueue(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.getCharQueue().put((byte)s.charAt(i));
        }
    }

    public String getResponse() throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.getResponse(AGateway.AsyncEvents.NOTHING);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getResponse(AGateway.AsyncEvents eventResponse) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.setLastError(-1);
        StringBuffer buffer = new StringBuffer(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
        try {
            String response;
            while (true) {
                if (this.getCharQueue().peek() == 10 || this.getCharQueue().peek() == 13) {
                    this.getCharQueue().get();
                    continue;
                }
                while (true) {
                    byte c = this.getCharQueue().get();
                    if (System.getProperty("smslib.dumpqueues") != null) {
                        Logger.getInstance().logDebug("OUT READER QUEUE : " + c + " / " + (char)c, null, this.getGateway().getGatewayId());
                    }
                    if (c == 10) break;
                    buffer.append((char)c);
                }
                if (buffer.charAt(buffer.length() - 1) != '\r') {
                    buffer.append('\r');
                }
                response = buffer.toString();
                if (this.getGateway().getATHandler().matchesTerminator(response)) break;
            }
            Logger.getInstance().logDebug("BUFFER: " + buffer, null, this.getGateway().getGatewayId());
            if (this.getGateway().getATHandler().isUnsolicitedResponse(buffer.toString())) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(buffer.toString());
                if (event == eventResponse && eventResponse != AGateway.AsyncEvents.NOTHING) {
                    return buffer.toString();
                }
                if (event != AGateway.AsyncEvents.INBOUNDMESSAGE && event != AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE && event != AGateway.AsyncEvents.INBOUNDCALL && event != AGateway.AsyncEvents.USSDRESPONSE) return this.getResponse();
                this.getAsyncNotifier().setEvent(event, buffer.toString());
                return this.getResponse();
            }
            if (response.matches(rxErrorWithCode)) {
                Pattern p = Pattern.compile(rxErrorWithCode);
                Matcher m = p.matcher(response);
                if (!m.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m.group(1).equals("CME")) {
                        int code = Integer.parseInt(m.group(2));
                        this.setLastError(5000 + code);
                    }
                    if (!m.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m.group(1));
                    int code = Integer.parseInt(m.group(2));
                    this.setLastError(6000 + code);
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().logDebug("Error on number conversion while interpreting response: ", null, this.getGateway().getGatewayId());
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.setLastError(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.setLastError(0);
            } else {
                this.setLastError(10000);
            }
            Logger.getInstance().logDebug("RECV :" + this.formatLog(buffer.toString()), null, this.getGateway().getGatewayId());
            return buffer.toString();
        }
        catch (InterruptedException e) {
            Logger.getInstance().logWarn("GetResponse() Interrupted.", e, this.getGateway().getGatewayId());
            throw e;
        }
        catch (TimeoutException e) {
            Logger.getInstance().logDebug("Buffer contents on timeout: " + buffer, null, this.getGateway().getGatewayId());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException, InterruptedException {
        Object object = this.getSYNCCommander();
        synchronized (object) {
            Logger.getInstance().logDebug("clearBuffer() called.", null, this.getGateway().getGatewayId());
            Thread.sleep(Service.getInstance().getSettings().SERIAL_CLEAR_WAIT);
            this.clear();
            this.getCharQueue().clear();
        }
    }

    protected boolean waitForNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        int retries = 0;
        String response;
        while ((response = this.getGateway().getATHandler().getNetworkRegistration()).indexOf("ERROR") < 0) {
            int answer;
            response = response.replaceAll("\\s+OK\\s+", "");
            response = response.replaceAll("\\s+", "");
            response = response.replaceAll("\\+CREG:", "");
            StringTokenizer tokens = new StringTokenizer(response, ",");
            tokens.nextToken();
            try {
                answer = Integer.parseInt(tokens.nextToken());
            }
            catch (Exception e) {
                answer = -1;
            }
            switch (answer) {
                case 0: {
                    Logger.getInstance().logError("GSM: Auto-registration disabled!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Auto-Registration disabled!");
                }
                case 1: {
                    Logger.getInstance().logInfo("GSM: Registered to home network.", null, this.getGateway().getGatewayId());
                    return true;
                }
                case 2: {
                    Logger.getInstance().logWarn("GSM: Not registered, searching for network...", null, this.getGateway().getGatewayId());
                    if (++retries != 6) break;
                    throw new GatewayException("GSM Network Registration failed, give up trying!");
                }
                case 3: {
                    Logger.getInstance().logError("GSM: Network registration denied!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Registration denied!");
                }
                case 4: {
                    Logger.getInstance().logError("GSM: Unknown registration error!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Registration error!");
                }
                case 5: {
                    Logger.getInstance().logInfo("GSM: Registered to foreign network (roaming).", null, this.getGateway().getGatewayId());
                    return true;
                }
                case -1: {
                    Logger.getInstance().logInfo("GSM: Invalid CREG response.", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM: Invalid CREG response.");
                }
            }
            Thread.sleep(Service.getInstance().getSettings().AT_WAIT_NETWORK);
        }
        return false;
    }

    private String formatLog(String s) {
        StringBuffer response = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    response.append("(cr)");
                    continue block5;
                }
                case '\n': {
                    response.append("(lf)");
                    continue block5;
                }
                case '\t': {
                    response.append("(tab)");
                    continue block5;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        response.append(c);
                        continue block5;
                    }
                    response.append("(" + c + ")");
                }
            }
        }
        return response.toString();
    }

    void setLastError(int myLastError) {
        this.lastError = myLastError;
    }

    public int getLastError() {
        return this.lastError;
    }

    public String getLastErrorText() {
        if (this.getLastError() == 0) {
            return "OK";
        }
        if (this.getLastError() == -1) {
            return "Invalid or empty response";
        }
        if (this.getLastError() / 1000 == 5) {
            return "CME Error " + this.getLastError() % 1000;
        }
        if (this.getLastError() / 1000 == 6) {
            return "CMS Error " + this.getLastError() % 1000;
        }
        return "Error: unknown";
    }

    public boolean isOk() {
        return this.getLastError() == OK;
    }

    protected ModemGateway getGateway() {
        return this.gateway;
    }

    protected void setGateway(ModemGateway myGateway) {
        this.gateway = myGateway;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean myConnected) {
        this.connected = myConnected;
    }

    protected boolean isDataReceived() {
        return this.dataReceived;
    }

    protected void setDataReceived(boolean myDataReceived) {
        this.dataReceived = myDataReceived;
    }

    protected CharQueue getCharQueue() {
        return this.charQueue;
    }

    protected void setCharQueue(CharQueue myCharQueue) {
        this.charQueue = myCharQueue;
    }

    protected Object getSYNCReader() {
        return this.SYNC_Reader;
    }

    protected void setSYNCReader(Object reader) {
        this.SYNC_Reader = reader;
    }

    protected Object getSYNCCommander() {
        return this.SYNC_Commander;
    }

    protected void setSYNCCommander(Object commander) {
        this.SYNC_Commander = commander;
    }

    protected Object getSYNCInboundReader() {
        return this.SYNC_InboundReader;
    }

    protected void setSYNCInboundReader(Object inbMessage) {
        this.SYNC_InboundReader = inbMessage;
    }

    protected KeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    protected void setKeepAlive(KeepAlive myKeepAlive) {
        this.keepAlive = myKeepAlive;
    }

    protected AsyncNotifier getAsyncNotifier() {
        return this.asyncNotifier;
    }

    protected void setAsyncNotifier(AsyncNotifier myAsyncNotifier) {
        this.asyncNotifier = myAsyncNotifier;
    }

    protected AsyncMessageProcessor getAsyncMessageProcessor() {
        return this.asyncMessageProcessor;
    }

    protected void setAsyncMessageProcessor(AsyncMessageProcessor myAsyncMessageProcessor) {
        this.asyncMessageProcessor = myAsyncMessageProcessor;
    }

    protected CNMIEmulatorProcessor getCnmiEmulationProcessor() {
        return this.cnmiEmulationProcessor;
    }

    protected void setCnmiEmulationProcessor(CNMIEmulatorProcessor myCnmiEmulationProcessor) {
        this.cnmiEmulationProcessor = myCnmiEmulationProcessor;
    }

    protected ModemReader getModemReader() {
        return this.modemReader;
    }

    protected void setModemReader(ModemReader myModemReader) {
        this.modemReader = myModemReader;
    }

    private class CNMIEmulatorProcessor
    extends AServiceThread {
        private List<InboundMessage> msgList;

        public CNMIEmulatorProcessor(String name, int delay) {
            super(name, delay, 0, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            if (AModemDriver.this.isConnected() && AModemDriver.this.getGateway().getStatus() == AGateway.GatewayStatuses.STARTED) {
                Object object = AModemDriver.this.getSYNCInboundReader();
                synchronized (object) {
                    this.msgList = new ArrayList<InboundMessage>();
                    AModemDriver.this.getGateway().readMessages(this.msgList, InboundMessage.MessageClasses.ALL);
                    for (InboundMessage msg : this.msgList) {
                        switch (msg.getType()) {
                            case INBOUND: 
                            case STATUSREPORT: {
                                Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(AModemDriver.this.getGateway(), msg.getType(), msg));
                            }
                        }
                    }
                    this.msgList.clear();
                }
            }
        }
    }

    private class AsyncMessageProcessor
    extends Thread {
        private List<InboundMessage> msgList = new ArrayList<InboundMessage>();
        private Object SYNC = new Object();
        private boolean process = false;

        public AsyncMessageProcessor() {
            this.setPriority(10);
            this.setName("SMSLib-AsyncMessageProcessor : " + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logDebug("AsyncMessageProcessor thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProcess() {
            Object object = this.SYNC;
            synchronized (object) {
                if (this.process) {
                    return;
                }
                this.process = true;
                this.SYNC.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AModemDriver.this.isConnected()) {
                try {
                    Object object = this.SYNC;
                    synchronized (object) {
                        if (!this.process) {
                            this.SYNC.wait();
                            if (!AModemDriver.this.isConnected()) {
                                break;
                            }
                        }
                    }
                    object = AModemDriver.this.getSYNCInboundReader();
                    synchronized (object) {
                        AModemDriver.this.getGateway().readMessages(this.msgList, InboundMessage.MessageClasses.ALL);
                        for (InboundMessage msg : this.msgList) {
                            switch (msg.getType()) {
                                case INBOUND: 
                                case STATUSREPORT: {
                                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(AModemDriver.this.getGateway(), msg.getType(), msg));
                                    break;
                                }
                            }
                        }
                    }
                    this.msgList.clear();
                    this.process = false;
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (GatewayException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (IOException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (TimeoutException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
            Logger.getInstance().logDebug("AsyncMessageProcessor thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }
    }

    private class AsyncNotifier
    extends Thread {
        private BlockingQueue<Event> eventQueue;
        private Object SYNC = new Object();

        public AsyncNotifier() {
            this.eventQueue = new LinkedBlockingQueue<Event>();
            this.setPriority(1);
            this.setName("SMSLib-AsyncNotifier : " + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logDebug("AsyncNotifier thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setEvent(AGateway.AsyncEvents event, String response) {
            Object object = this.SYNC;
            synchronized (object) {
                Event ev = new Event(event, response);
                Logger.getInstance().logDebug("Storing AsyncEvent: " + ev, null, AModemDriver.this.getGateway().getGatewayId());
                this.eventQueue.add(ev);
                this.SYNC.notify();
            }
        }

        protected String getOriginator(String indication) {
            Pattern p = Pattern.compile("\\+?\"\\S+\"");
            Matcher m = p.matcher(indication);
            if (m.find()) {
                return indication.substring(m.start(), m.end()).replaceAll("\"", "");
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AModemDriver.this.isConnected()) {
                try {
                    String response;
                    Event event = this.eventQueue.take();
                    Logger.getInstance().logDebug("Processing AsyncEvent: " + event, null, AModemDriver.this.getGateway().getGatewayId());
                    if (event.event == AGateway.AsyncEvents.INBOUNDMESSAGE) {
                        Logger.getInstance().logDebug("Inbound message detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.event = AGateway.AsyncEvents.NOTHING;
                        response = event.response;
                        AModemDriver.this.getAsyncMessageProcessor().setProcess();
                        continue;
                    }
                    if (event.event == AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE) {
                        Logger.getInstance().logDebug("Inbound status report message detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.event = AGateway.AsyncEvents.NOTHING;
                        response = event.response;
                        AModemDriver.this.getAsyncMessageProcessor().setProcess();
                        continue;
                    }
                    if (event.event == AGateway.AsyncEvents.INBOUNDCALL) {
                        Logger.getInstance().logDebug("Inbound call detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.event = AGateway.AsyncEvents.NOTHING;
                        Object object = AModemDriver.this.getSYNCCommander();
                        synchronized (object) {
                            AModemDriver.this.getGateway().getATHandler().switchToCmdMode();
                            AModemDriver.this.getGateway().getModemDriver().write("ATH\r");
                            AModemDriver.this.getGateway().getModemDriver().getResponse();
                            response = event.response;
                        }
                        Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new CallNotification(AModemDriver.this.getGateway(), this.getOriginator(response)));
                        continue;
                    }
                    if (event.event != AGateway.AsyncEvents.USSDRESPONSE) continue;
                    Logger.getInstance().logDebug("Inbound USSD response detected!", null, AModemDriver.this.getGateway().getGatewayId());
                    event.event = AGateway.AsyncEvents.NOTHING;
                    response = event.response;
                    Logger.getInstance().logDebug("USSD response : " + AModemDriver.this.formatLog(response), null, AModemDriver.this.getGateway().getGatewayId());
                    if (Service.getInstance().getUSSDNotification() == null) continue;
                    USSDResponse ussdResponse = new USSDResponse(response, AModemDriver.this.getGateway().getGatewayId());
                    ussdResponse.setContent(AModemDriver.this.getGateway().getATHandler().formatUSSDResponse(ussdResponse.getContent()));
                    Service.getInstance().getUSSDNotification().process(AModemDriver.this.getGateway(), ussdResponse);
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (InvalidMessageException e) {
                    Logger.getInstance().logInfo("Invalid Message received! Ignoring. ", e, AModemDriver.this.getGateway().getGatewayId());
                }
                catch (GatewayException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (IOException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (TimeoutException e) {
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
            Logger.getInstance().logDebug("AsyncNotifier thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        class Event {
            AGateway.AsyncEvents event;
            String response;

            public Event(AGateway.AsyncEvents myEvent, String myResponse) {
                this.event = myEvent;
                this.response = myResponse;
            }

            public String toString() {
                return "Event: " + (Object)((Object)this.event) + " / Response: " + this.response;
            }
        }
    }

    private class KeepAlive
    extends AServiceThread {
        public KeepAlive(String name, int delay) {
            super(name, delay, 0, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            block11: {
                try {
                    if (!AModemDriver.this.isConnected()) {
                        return;
                    }
                    if (AModemDriver.this.getGateway().getStatus() != AGateway.GatewayStatuses.STARTED) break block11;
                    Object object = AModemDriver.this.getSYNCCommander();
                    synchronized (object) {
                        if (!AModemDriver.this.isConnected()) {
                            return;
                        }
                        try {
                            if (!AModemDriver.this.getGateway().getATHandler().isAlive()) {
                                AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                            }
                            if (!AModemDriver.this.getCnmiEmulationProcessor().isEnabled()) {
                                AModemDriver.this.getAsyncMessageProcessor().setProcess();
                            }
                        }
                        catch (Exception e) {
                            AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.getInstance().logError("ModemDriver: KeepAlive Error.", e, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
        }
    }

    private class ModemReader
    extends Thread {
        public ModemReader() {
            this.setName("SMSlib-ModemReader-" + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logDebug("ModemReader thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: while (AModemDriver.this.isConnected()) {
                try {
                    Object object = AModemDriver.this.getSYNCReader();
                    synchronized (object) {
                        if (!AModemDriver.this.isDataReceived()) {
                            AModemDriver.this.getSYNCReader().wait();
                        }
                        if (!AModemDriver.this.isConnected()) {
                            break;
                        }
                        int c = AModemDriver.this.read();
                        while (c != -1) {
                            AModemDriver.this.getCharQueue().put((byte)c);
                            if (!AModemDriver.this.portHasData()) break;
                            c = AModemDriver.this.read();
                        }
                        AModemDriver.this.setDataReceived(false);
                    }
                    String data = AModemDriver.this.getCharQueue().peek(6);
                    for (int i = 0; i < AModemDriver.this.getGateway().getATHandler().getUnsolicitedResponses().length; ++i) {
                        if (data.indexOf(AModemDriver.this.getGateway().getATHandler().getUnsolicitedResponse(i)) < 0) continue;
                        Thread.sleep(100L);
                        AModemDriver.this.getKeepAlive().interrupt();
                        continue block6;
                    }
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Logger.getInstance().logDebug("ModemReader thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }
    }

    private class CharQueue {
        byte[] buffer = null;
        int bufferStart = 0;
        int bufferEnd = 0;

        public synchronized void put(byte c) {
            if (this.buffer == null) {
                this.buffer = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            this.buffer[this.bufferEnd] = c;
            ++this.bufferEnd;
            if (this.bufferEnd == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                this.bufferEnd = 0;
            }
            if (System.getProperty("smslib.dumpqueues") != null) {
                Logger.getInstance().logDebug("IN READER QUEUE : " + c + " / " + (char)c, null, AModemDriver.this.getGateway().getGatewayId());
            }
            this.notifyAll();
        }

        public synchronized byte get() throws TimeoutException, InterruptedException {
            if (this.buffer == null) {
                this.buffer = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.bufferStart == this.bufferEnd) {
                        this.wait(Service.getInstance().getSettings().SERIAL_TIMEOUT);
                    }
                    if (this.bufferStart == this.bufferEnd) {
                        throw new TimeoutException("No response from device.");
                    }
                    byte c = this.buffer[this.bufferStart];
                    ++this.bufferStart;
                    if (this.bufferStart == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                        this.bufferStart = 0;
                    }
                    return c;
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.getGateway().getStatus() == AGateway.GatewayStatuses.STARTED) {
                        Logger.getInstance().logWarn("Ignoring InterruptedException in Queue.get().", null, AModemDriver.this.getGateway().getGatewayId());
                        continue;
                    }
                    Logger.getInstance().logWarn("Re-throwing InterruptedException in Queue.get() - should be during shutdown...", null, AModemDriver.this.getGateway().getGatewayId());
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized byte peek() throws InterruptedException {
            if (this.buffer == null) {
                this.buffer = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.bufferStart == this.bufferEnd) {
                        this.wait(Service.getInstance().getSettings().SERIAL_TIMEOUT);
                    }
                    if (this.bufferStart == this.bufferEnd) {
                        return -1;
                    }
                    return this.buffer[this.bufferStart];
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.getGateway().getStatus() == AGateway.GatewayStatuses.STARTED) {
                        Logger.getInstance().logWarn("Ignoring InterruptedException in Queue.peek().", e, AModemDriver.this.getGateway().getGatewayId());
                        continue;
                    }
                    Logger.getInstance().logWarn("Re-throwing InterruptedException in Queue.peek() - should be during shutdown...", e, AModemDriver.this.getGateway().getGatewayId());
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized String peek(int sizeToRead) {
            if (this.buffer == null) {
                this.buffer = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            int size = sizeToRead;
            if (this.bufferStart == this.bufferEnd) {
                return "";
            }
            StringBuffer result = new StringBuffer(size);
            int i = this.bufferStart;
            while (size > 0) {
                if (this.buffer[i] != 10 && this.buffer[i] != 13) {
                    result.append((char)this.buffer[i]);
                    --size;
                }
                if (++i == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                    i = 0;
                }
                if (i != this.bufferEnd) continue;
                break;
            }
            return result.toString();
        }

        public synchronized void clear() {
            this.bufferStart = 0;
            this.bufferEnd = 0;
        }
    }
}

