/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.smslib.GatewayException;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;
import org.smslib.helper.Logger;
import org.smslib.http.HTTPGateway;

public class SkypeHTTPGateway
extends HTTPGateway {
    String password;
    String reply;
    String providerHost;
    Object SYNC_Commander;

    public SkypeHTTPGateway(String id, String myProviderHost, String myPassword, String myReply) {
        super(id);
        this.providerHost = myProviderHost;
        this.password = myPassword;
        this.reply = myReply;
        this.SYNC_Commander = new Object();
        this.setAttributes(77);
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway.", null, this.getGatewayId());
        super.startGateway();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Stopping gateway.", null, this.getGatewayId());
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        try {
            List<String> response;
            URL url = null;
            ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
            boolean ok = false;
            request.add(new HTTPGateway.HttpHeader("password", this.password, false));
            request.add(new HTTPGateway.HttpHeader("text", msg.getText(), false));
            request.add(new HTTPGateway.HttpHeader("to", msg.getRecipient(), false));
            request.add(new HTTPGateway.HttpHeader("reply", this.reply, false));
            String reqLine = this.ExpandHttpHeaders(request);
            url = new URL(this.providerHost + "/send" + "?" + reqLine);
            System.out.println(">>>>>>>>>>>> " + url.toString());
            Object object = this.SYNC_Commander;
            synchronized (object) {
                response = this.HttpGet(url);
            }
            System.out.println(">>>>>>>>>>>>>>>>>>>>>  " + response.get(0));
            switch (Integer.parseInt(response.get(0))) {
                case 0: {
                    msg.setRefNo("N/A");
                    msg.setDispatchDate(new Date());
                    msg.setGatewayId(this.getGatewayId());
                    msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                    this.incOutboundMessageCount();
                    ok = true;
                    break;
                }
                default: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                    msg.setRefNo(null);
                    msg.setDispatchDate(null);
                    msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                    ok = false;
                }
            }
            return ok;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

