/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.smslib.crypto.ASymmetricKey;

public class AESKey
extends ASymmetricKey {
    public AESKey() throws NoSuchAlgorithmException {
        this.setKey(this.generateKey());
    }

    public AESKey(SecretKeySpec key) {
        this.setKey(key);
    }

    @Override
    public SecretKeySpec generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        byte[] raw = secretKey.getEncoded();
        return new SecretKeySpec(raw, "AES");
    }

    @Override
    public byte[] encrypt(byte[] message) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.getKey());
        return cipher.doFinal(message);
    }

    @Override
    public byte[] decrypt(byte[] message) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, this.getKey());
        return cipher.doFinal(message);
    }

    public static void main(String[] args) {
        try {
            AESKey k = new AESKey();
            k.setKey(k.generateKey());
            String message = "Hello from Thanasis :)";
            System.out.println(">>> " + message);
            byte[] enc = k.encrypt(message.getBytes());
            byte[] dec = k.decrypt(enc);
            System.out.println(">>> " + AESKey.asString(dec));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

