/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.util.Calendar;
import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduUtils;

public class SmsSubmitPdu
extends Pdu {
    private int messageReference = 0;
    private int validityPeriod = -1;
    private Calendar validityPeriodTimeStamp;

    public void setTpRd(int value) {
        this.setFirstOctetField(251, value, new int[]{0, 4});
    }

    public boolean hasTpRd() {
        return this.getFirstOctetField(251) == 4;
    }

    public void setTpVpf(int value) {
        this.setFirstOctetField(231, value, new int[]{16, 0, 24});
    }

    public int getTpVpf() {
        return this.getFirstOctetField(231);
    }

    public boolean hasTpVpf() {
        return this.getFirstOctetField(231) != 0;
    }

    public void setTpSrr(int value) {
        this.setFirstOctetField(223, value, new int[]{0, 32});
    }

    public boolean hasTpSrr() {
        return this.getFirstOctetField(223) == 32;
    }

    public void setMessageReference(int reference) {
        this.messageReference = reference;
    }

    public int getMessageReference() {
        return this.messageReference;
    }

    public int getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(int validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public void setValidityTimestamp(Calendar date) {
        this.validityPeriodTimeStamp = date;
    }

    public Date getValidityDate() {
        return this.validityPeriodTimeStamp.getTime();
    }

    public Calendar getValidityDateAsCalendar() {
        return this.validityPeriodTimeStamp;
    }

    @Override
    protected String pduSubclassInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Reference: " + PduUtils.byteToPdu(this.getMessageReference()));
        sb.append("\n");
        if (this.getAddress() != null) {
            sb.append("Destination Address: [Length: " + this.getAddress().length() + " (" + PduUtils.byteToPdu((byte)this.getAddress().length()) + ")");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append(", Address: " + this.getAddress());
            sb.append("]");
        } else {
            sb.append("Destination Address: [Length: 0");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append("]");
        }
        sb.append("\n");
        sb.append("TP-PID: " + PduUtils.byteToPdu(this.getProtocolIdentifier()) + " (" + PduUtils.byteToBits((byte)this.getProtocolIdentifier()) + ")");
        sb.append("\n");
        sb.append("TP-DCS: " + PduUtils.byteToPdu(this.getDataCodingScheme()) + " (" + PduUtils.decodeDataCodingScheme(this) + ") (" + PduUtils.byteToBits((byte)this.getDataCodingScheme()) + ")");
        sb.append("\n");
        switch (this.getTpVpf()) {
            case 16: {
                sb.append("TP-VPF: " + this.getValidityPeriod() + " hours");
                break;
            }
            case 24: {
                sb.append("TP-VPF: " + this.formatTimestamp(this.getValidityDateAsCalendar()));
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

