/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.google.common.base.Charsets;
import com.sampullara.mustache.BuilderCodeFactory;
import com.sampullara.mustache.Code;
import com.sampullara.mustache.CodeFactory;
import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheContext;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.MustacheJava;
import com.sampullara.mustache.WriteCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MustacheBuilder
implements MustacheJava {
    private Class<? extends Mustache> superclass;
    private CodeFactory cf = new BuilderCodeFactory();
    private MustacheContext mc;

    public MustacheBuilder() {
        this((String)null);
    }

    public MustacheBuilder(final String classpath) {
        this(new MustacheContext(){

            @Override
            public BufferedReader getReader(String path) throws MustacheException {
                String fullPath = classpath == null ? path : classpath + "/" + path;
                InputStream resourceAsStream = MustacheBuilder.class.getClassLoader().getResourceAsStream(fullPath);
                if (resourceAsStream == null) {
                    throw new MustacheException(path + " not found in classpath");
                }
                return new BufferedReader(new InputStreamReader(resourceAsStream, Charsets.UTF_8));
            }
        });
    }

    public MustacheBuilder(final File root) {
        this(new MustacheContext(){

            @Override
            public BufferedReader getReader(String path) throws MustacheException {
                try {
                    return new BufferedReader(new FileReader(new File(root, path)));
                }
                catch (FileNotFoundException e) {
                    throw new MustacheException("Failed to find path: " + path, (Exception)e);
                }
            }
        });
    }

    public MustacheBuilder(MustacheContext mc) {
        this.mc = mc;
    }

    public void setSuperclass(String superclass) {
        try {
            this.superclass = Class.forName(superclass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class", e);
        }
    }

    public Mustache parse(String template, String path) throws MustacheException {
        return this.build(new StringReader(template), path);
    }

    public Mustache build(Reader br, String path) throws MustacheException {
        Mustache mustache;
        try {
            mustache = this.superclass == null ? new Mustache() : this.superclass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate", e);
        }
        mustache.setMustacheJava((MustacheJava)this);
        mustache.setName(path);
        mustache.setCompiled(this.compile(mustache, br, null, new AtomicInteger(0), path));
        return mustache;
    }

    public Mustache parseFile(String path) throws MustacheException {
        return this.build(this.mc.getReader(path), path);
    }

    protected List<Code> compile(Mustache m, Reader br, String tag, AtomicInteger currentLine, String file) throws MustacheException {
        LinkedList<Code> list = new LinkedList<Code>();
        String sm = "{{";
        String em = "}}";
        boolean onlywhitespace = true;
        boolean iterable = currentLine.get() != 0;
        currentLine.compareAndSet(0, 1);
        StringBuilder out = new StringBuilder();
        try {
            int c;
            block19: while ((c = br.read()) != -1) {
                if (c == 13) continue;
                if (c == 10) {
                    currentLine.incrementAndGet();
                    if (!iterable || iterable && !onlywhitespace) {
                        out.append("\n");
                    }
                    out = this.write(list, out, currentLine.intValue());
                    iterable = false;
                    onlywhitespace = true;
                    continue;
                }
                if (c == sm.charAt(0)) {
                    br.mark(1);
                    if (br.read() == sm.charAt(1)) {
                        StringBuilder sb = new StringBuilder();
                        while ((c = br.read()) != -1) {
                            br.mark(1);
                            if (c == em.charAt(0)) {
                                if (br.read() == em.charAt(1)) break;
                                br.reset();
                            }
                            sb.append((char)c);
                        }
                        String command = sb.toString().trim();
                        char ch = command.charAt(0);
                        String variable = command.substring(1).trim();
                        switch (ch) {
                            case '#': 
                            case '$': 
                            case '<': 
                            case '=': 
                            case '?': 
                            case '^': 
                            case '_': {
                                int start = currentLine.get();
                                List<Code> codes = this.compile(m, br, variable, currentLine, file);
                                int lines = currentLine.get() - start;
                                if (!onlywhitespace || lines == 0) {
                                    this.write(list, out, currentLine.intValue());
                                }
                                out = new StringBuilder();
                                switch (ch) {
                                    case '#': {
                                        list.add(this.cf.iterable(m, variable, codes, file, currentLine.get()));
                                        break;
                                    }
                                    case '^': {
                                        list.add(this.cf.notIterable(m, variable, codes, file, currentLine.get()));
                                        break;
                                    }
                                    case '?': {
                                        list.add(this.cf.ifIterable(m, variable, codes, file, currentLine.get()));
                                        break;
                                    }
                                    case '_': {
                                        list.add(this.cf.function(m, variable, codes, file, currentLine.get()));
                                        break;
                                    }
                                    case '<': {
                                        list.add(this.cf.extend(m, variable, codes, file, currentLine.get()));
                                        break;
                                    }
                                    case '$': {
                                        list.add(this.cf.name(m, variable, codes, file, currentLine.get()));
                                    }
                                }
                                iterable = lines != 0;
                                continue block19;
                            }
                            case '/': {
                                if (!onlywhitespace) {
                                    this.write(list, out, currentLine.intValue());
                                }
                                if (!variable.equals(tag)) {
                                    throw new MustacheException("Mismatched start/end tags: " + tag + " != " + variable + " in " + file + ":" + currentLine);
                                }
                                return list;
                            }
                            case '>': {
                                out = this.write(list, out, currentLine.intValue());
                                list.add(this.cf.partial(m, variable, file, currentLine.get()));
                                continue block19;
                            }
                            case '{': {
                                out = this.write(list, out, currentLine.intValue());
                                String name = variable;
                                if (em.charAt(1) != '}') {
                                    name = variable.substring(0, variable.length() - 1);
                                } else if (br.read() != 125) {
                                    throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
                                }
                                String finalName = name;
                                list.add(this.cf.value(m, finalName, false, currentLine.intValue()));
                                continue block19;
                            }
                            case '&': {
                                out = this.write(list, out, currentLine.intValue());
                                list.add(this.cf.value(m, variable, false, currentLine.intValue()));
                                continue block19;
                            }
                            case '%': {
                                out = this.write(list, out, currentLine.intValue());
                                continue block19;
                            }
                            case '!': {
                                out = this.write(list, out, currentLine.intValue());
                                continue block19;
                            }
                        }
                        if (c == -1) {
                            throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
                        }
                        out = this.write(list, out, currentLine.intValue());
                        list.add(this.cf.value(m, command, true, currentLine.intValue()));
                        continue;
                    }
                    br.reset();
                }
                onlywhitespace = (c == 32 || c == 9) && onlywhitespace;
                out.append((char)c);
            }
            this.write(list, out, currentLine.intValue());
            br.close();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to read", (Exception)e);
        }
        list.add(this.cf.eof(currentLine.intValue()));
        return list;
    }

    private StringBuilder write(List<Code> list, StringBuilder out, int line) {
        String text = out.toString();
        if (text.length() > 0) {
            Code code;
            int size = list.size();
            if (size > 0 && (code = list.get(size - 1)) instanceof WriteCode) {
                WriteCode writeCode = (WriteCode)code;
                writeCode.append(text);
            } else {
                list.add(this.cf.write(text, line));
            }
        }
        return new StringBuilder();
    }
}

